/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.extensions.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.WriteableSetting;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;

public class RegisterCustomSettingsRequest
extends TransportRequest {
    private String uniqueId;
    private List<Setting<?>> settings;

    public RegisterCustomSettingsRequest(String uniqueId, List<Setting<?>> settings) {
        this.uniqueId = uniqueId;
        this.settings = new ArrayList(settings);
    }

    public RegisterCustomSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.uniqueId = in.readString();
        int size = in.readVInt();
        this.settings = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            WriteableSetting ws = new WriteableSetting(in);
            this.settings.add(ws.getSetting());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.uniqueId);
        out.writeVInt(this.settings.size());
        for (Setting<?> setting : this.settings) {
            new WriteableSetting(setting).writeTo(out);
        }
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public List<Setting<?>> getSettings() {
        return new ArrayList(this.settings);
    }

    public String toString() {
        return "RegisterSettingsRequest{uniqueId=" + this.uniqueId + ", settings=" + this.settings + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterCustomSettingsRequest that = (RegisterCustomSettingsRequest)obj;
        return Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.settings);
    }
}

