/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class TaskThreadUsage
implements Writeable,
ToXContentFragment {
    private static final String THREAD_EXECUTIONS = "thread_executions";
    private static final String ACTIVE_THREADS = "active_threads";
    private static final ParseField THREAD_EXECUTION_COUNT = new ParseField("thread_executions", new String[0]);
    private static final ParseField ACTIVE_THREAD_COUNT = new ParseField("active_threads", new String[0]);
    private final int threadExecutions;
    private final int activeThreads;
    public static final ConstructingObjectParser<TaskThreadUsage, Void> PARSER = new ConstructingObjectParser("task_thread_executions", a -> new TaskThreadUsage((Integer)a[0], (Integer)a[1]));

    public TaskThreadUsage(int threadExecutions, int activeThreads) {
        this.threadExecutions = threadExecutions;
        this.activeThreads = activeThreads;
    }

    public static TaskThreadUsage readFromStream(StreamInput in) throws IOException {
        return new TaskThreadUsage(in.readInt(), in.readInt());
    }

    public int getThreadExecutions() {
        return this.threadExecutions;
    }

    public int getActiveThreads() {
        return this.activeThreads;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(THREAD_EXECUTIONS, this.threadExecutions);
        builder.field(ACTIVE_THREADS, this.activeThreads);
        return builder;
    }

    public static TaskThreadUsage fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.threadExecutions);
        out.writeInt(this.activeThreads);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskThreadUsage.class) {
            return false;
        }
        TaskThreadUsage other = (TaskThreadUsage)obj;
        return Objects.equals(this.threadExecutions, other.threadExecutions) && Objects.equals(this.activeThreads, other.activeThreads);
    }

    public int hashCode() {
        return Objects.hash(this.threadExecutions, this.activeThreads);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), THREAD_EXECUTION_COUNT);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), ACTIVE_THREAD_COUNT);
    }
}

