/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonEncoding;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonFactory;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonGenerator;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonParser;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.StreamReadConstraints;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.StreamReadFeature;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.StreamWriteFeature;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.json.JsonXContentGenerator;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.json.JsonXContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentGenerator;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class JsonXContent
implements XContent {
    public static final int DEFAULT_MAX_STRING_LEN = Integer.parseInt(System.getProperty("opensearch.xcontent.string.length.max", Integer.toString(Integer.MAX_VALUE)));
    public static final boolean USE_FAST_DOUBLE_WRITER = Boolean.getBoolean("opensearch.xcontent.use_fast_double_writer");
    private static final JsonFactory jsonFactory = new JsonFactory();
    public static final JsonXContent jsonXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(jsonXContent);
    }

    private JsonXContent() {
    }

    @Override
    public MediaType mediaType() {
        return XContentType.JSON;
    }

    @Override
    public byte streamSeparator() {
        return 10;
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new JsonXContentGenerator(jsonFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(content));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(data));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(data, offset, length));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new JsonXContentParser(xContentRegistry, deprecationHandler, jsonFactory.createParser(reader));
    }

    static {
        jsonFactory.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        jsonFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        jsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(DEFAULT_MAX_STRING_LEN).build());
        jsonFactory.configure(StreamReadFeature.USE_FAST_DOUBLE_PARSER.mappedFeature(), true);
        jsonFactory.configure(StreamWriteFeature.USE_FAST_DOUBLE_WRITER.mappedFeature(), USE_FAST_DOUBLE_WRITER);
        jsonXContent = new JsonXContent();
    }
}

