/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;

public final class IOUtils {
    public static final String UTF_8 = StandardCharsets.UTF_8.name();
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final boolean LINUX = System.getProperty("os.name").startsWith("Linux");
    public static final boolean MAC_OS_X = System.getProperty("os.name").startsWith("Mac OS X");

    private IOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        IOUtils.close(null, Arrays.asList(objects));
    }

    public static void close(@Nullable Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(Exception e, Closeable ... objects) throws IOException {
        IOUtils.close(e, Arrays.asList(objects));
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        IOUtils.close(null, objects);
    }

    public static void close(Exception ex, Iterable<? extends Closeable> objects) throws IOException {
        Exception firstException = ex;
        for (Closeable closeable : objects) {
            try {
                IOUtils.close(closeable);
            }
            catch (IOException | RuntimeException e) {
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        if (firstException != null) {
            if (firstException instanceof IOException) {
                throw (IOException)firstException;
            }
            throw (RuntimeException)firstException;
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        IOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        for (Closeable closeable : objects) {
            IOUtils.closeWhileHandlingException(closeable);
        }
    }

    public static void closeWhileHandlingException(Closeable closeable) {
        try {
            IOUtils.close(closeable);
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
    }

    public static void deleteFilesIgnoringExceptions(Path ... files) {
        IOUtils.deleteFilesIgnoringExceptions(Arrays.asList(files));
    }

    public static void deleteFilesIgnoringExceptions(Collection<? extends Path> files) {
        for (Path path : files) {
            if (path == null) continue;
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {}
        }
    }

    public static void rm(Path ... locations) throws IOException {
        LinkedHashMap<Path, Throwable> unremoved = IOUtils.rm(new LinkedHashMap<Path, Throwable>(), locations);
        if (!unremoved.isEmpty()) {
            StringBuilder b = new StringBuilder("could not remove the following files (in the order of attempts):\n");
            for (Map.Entry<Path, Throwable> kv : unremoved.entrySet()) {
                b.append("   ").append(kv.getKey().toAbsolutePath()).append(": ").append(kv.getValue()).append("\n");
            }
            throw new IOException(b.toString());
        }
    }

    private static LinkedHashMap<Path, Throwable> rm(final LinkedHashMap<Path, Throwable> unremoved, Path ... locations) {
        if (locations != null) {
            for (Path location : locations) {
                if (location == null || !Files.exists(location, new LinkOption[0])) continue;
                try {
                    Files.walkFileTree(location, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException impossible) throws IOException {
                            assert (impossible == null);
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                unremoved.put(dir, e);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            try {
                                Files.delete(file);
                            }
                            catch (IOException exc) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            if (exc != null) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException impossible) {
                    throw new AssertionError("visitor threw exception", impossible);
                }
            }
        }
        return unremoved;
    }

    public static void fsync(Path fileToSync, boolean isDir) throws IOException {
        if (isDir && WINDOWS) {
            if (!Files.exists(fileToSync, new LinkOption[0])) {
                throw new NoSuchFileException(fileToSync.toString());
            }
            return;
        }
        try (FileChannel file = FileChannel.open(fileToSync, isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            try {
                file.force(true);
            }
            catch (IOException e) {
                if (isDir) {
                    assert (!(LINUX || MAC_OS_X)) : "on Linux and MacOSX fsyncing a directory should not throw IOException, we just don't want to rely on that in production (undocumented); got: " + e;
                    if (file != null) {
                        file.close();
                    }
                    return;
                }
                throw e;
            }
        }
    }
}

