/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.util;

import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RateLimiter;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;

public class CombinedRateLimiter {
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final RateLimiter.SimpleRateLimiter rateLimiter;
    private volatile boolean rateLimit;

    public CombinedRateLimiter(ByteSizeValue maxBytesPerSec) {
        this.rateLimit = maxBytesPerSec.getBytes() > 0L;
        this.rateLimiter = new RateLimiter.SimpleRateLimiter(maxBytesPerSec.getMbFrac());
    }

    public long maybePause(int bytes) {
        long bytesSincePause;
        if (this.rateLimit && (bytesSincePause = this.bytesSinceLastPause.addAndGet(bytes)) > this.rateLimiter.getMinPauseCheckBytes()) {
            this.bytesSinceLastPause.addAndGet(-bytesSincePause);
            return Math.max(this.rateLimiter.pause(bytesSincePause), 0L);
        }
        return 0L;
    }

    public void setMBPerSec(ByteSizeValue maxBytesPerSec) {
        this.rateLimit = maxBytesPerSec.getBytes() > 0L;
        this.rateLimiter.setMBPerSec(maxBytesPerSec.getMbFrac());
    }

    public double getMBPerSec() {
        return this.rateLimiter.getMBPerSec();
    }
}

