/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

class LoggingOutputStream
extends OutputStream {
    static final int DEFAULT_BUFFER_LENGTH = 1024;
    static final int MAX_BUFFER_LENGTH = 65536;
    ThreadLocal<Buffer> threadLocal = ThreadLocal.withInitial(() -> new Buffer());
    private final Logger logger;
    private final Level level;

    LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.threadLocal == null) {
            throw new IOException("buffer closed");
        }
        if (b == 0) {
            return;
        }
        if (b == 10) {
            this.flush();
            return;
        }
        Buffer buffer = this.threadLocal.get();
        if (buffer.used == buffer.bytes.length) {
            if (buffer.bytes.length >= 65536) {
                this.flush();
                buffer = this.threadLocal.get();
            } else {
                buffer.bytes = Arrays.copyOf(buffer.bytes, 2 * buffer.bytes.length);
            }
        }
        buffer.bytes[buffer.used++] = (byte)b;
    }

    @Override
    public void flush() {
        Buffer buffer = this.threadLocal.get();
        if (buffer.used == 0) {
            return;
        }
        int used = buffer.used;
        if (buffer.bytes[used - 1] == 13) {
            --used;
        }
        if (used == 0) {
            buffer.used = 0;
            return;
        }
        this.log(new String(buffer.bytes, 0, used, StandardCharsets.UTF_8));
        if (buffer.bytes.length != 1024) {
            this.threadLocal.set(new Buffer());
        } else {
            buffer.used = 0;
        }
    }

    @Override
    public void close() {
        this.threadLocal = null;
    }

    void log(String msg) {
        this.logger.log(this.level, msg);
    }

    class Buffer {
        byte[] bytes = new byte[1024];
        int used = 0;

        Buffer() {
        }
    }
}

