/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Member;
import org.graylog.shaded.opensearch2.org.opensearch.common.Classes;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.BindingAnnotation;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Key;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.ScopeAnnotation;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.TypeLiteral;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.internal.Errors;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.internal.ErrorsException;

public class Annotations {
    public static boolean isRetainedAtRuntime(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        return retention != null && retention.value() == RetentionPolicy.RUNTIME;
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Class<?> implementation) {
        return Annotations.findScopeAnnotation(errors, implementation.getAnnotations());
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Annotation[] annotations) {
        Class<? extends Annotation> found = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getAnnotation(ScopeAnnotation.class) == null) continue;
            if (found != null) {
                errors.duplicateScopeAnnotations(found, annotation.annotationType());
                continue;
            }
            found = annotation.annotationType();
        }
        return found;
    }

    public static boolean isScopeAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType.getAnnotation(ScopeAnnotation.class) != null;
    }

    public static void checkForMisplacedScopeAnnotations(Class<?> type, Object source, Errors errors) {
        if (Classes.isConcrete(type)) {
            return;
        }
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, type);
        if (scopeAnnotation != null) {
            errors.withSource(type).scopeAnnotationOnAbstractType(scopeAnnotation, type, source);
        }
    }

    public static Key<?> getKey(TypeLiteral<?> type, Member member, Annotation[] annotations, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        Annotation found = Annotations.findBindingAnnotation(errors, member, annotations);
        errors.throwIfNewErrors(numErrorsBefore);
        return found == null ? Key.get(type) : Key.get(type, found);
    }

    public static Annotation findBindingAnnotation(Errors errors, Member member, Annotation[] annotations) {
        Annotation found = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getAnnotation(BindingAnnotation.class) == null) continue;
            if (found != null) {
                errors.duplicateBindingAnnotations(member, found.annotationType(), annotation.annotationType());
                continue;
            }
            found = annotation;
        }
        return found;
    }
}

