/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.blobstore;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.CryptoMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.AsyncMultiStreamBlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.AsyncMultiStreamEncryptedBlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.EncryptedBlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.crypto.CryptoHandler;
import org.graylog.shaded.opensearch2.org.opensearch.crypto.CryptoHandlerRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.crypto.CryptoRegistryException;

public class EncryptedBlobStore
implements BlobStore {
    private final BlobStore blobStore;
    private final CryptoHandler<?, ?> cryptoHandler;

    public EncryptedBlobStore(BlobStore blobStore, CryptoMetadata cryptoMetadata) {
        CryptoHandlerRegistry cryptoHandlerRegistry = CryptoHandlerRegistry.getInstance();
        assert (cryptoHandlerRegistry != null) : "CryptoManagerRegistry is not initialized";
        this.cryptoHandler = cryptoHandlerRegistry.fetchCryptoHandler(cryptoMetadata);
        if (this.cryptoHandler == null) {
            throw new CryptoRegistryException(cryptoMetadata.keyProviderName(), cryptoMetadata.keyProviderType(), "Crypto manager not found during encrypted blob store creation.");
        }
        this.blobStore = blobStore;
    }

    @Override
    public BlobContainer blobContainer(BlobPath path) {
        BlobContainer blobContainer = this.blobStore.blobContainer(path);
        if (blobContainer instanceof AsyncMultiStreamBlobContainer) {
            return new AsyncMultiStreamEncryptedBlobContainer((AsyncMultiStreamBlobContainer)blobContainer, this.cryptoHandler);
        }
        return new EncryptedBlobContainer(blobContainer, this.cryptoHandler);
    }

    @Override
    public Map<String, Long> stats() {
        return this.blobStore.stats();
    }

    @Override
    public void close() throws IOException {
        this.cryptoHandler.close();
        this.blobStore.close();
    }
}

