/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IntroSorter;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardMovementStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.UnassignedInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocationConstraints;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.MoveDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RebalanceConstraints;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.ShardAllocationDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.LocalShardsBalancer;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.RemoteShardsBalancer;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.ShardsBalancer;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;

public class BalancedShardsAllocator
implements ShardsAllocator {
    private static final Logger logger = LogManager.getLogger(BalancedShardsAllocator.class);
    public static final Setting<Float> INDEX_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.index", 0.55f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> SHARD_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.shard", 0.45f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SHARD_MOVE_PRIMARY_FIRST_SETTING = Setting.boolSetting("cluster.routing.allocation.move.primary_first", false, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<ShardMovementStrategy> SHARD_MOVEMENT_STRATEGY_SETTING = new Setting<ShardMovementStrategy>("cluster.routing.allocation.shard_movement_strategy", ShardMovementStrategy.NO_PREFERENCE.toString(), ShardMovementStrategy::parse, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> THRESHOLD_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.threshold", 1.0f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> PREFER_PRIMARY_SHARD_BALANCE = Setting.boolSetting("cluster.routing.allocation.balance.prefer_primary", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean movePrimaryFirst;
    private volatile ShardMovementStrategy shardMovementStrategy;
    private volatile boolean preferPrimaryShardBalance;
    private volatile WeightFunction weightFunction;
    private volatile float threshold;

    public BalancedShardsAllocator(Settings settings) {
        this(settings, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    @Inject
    public BalancedShardsAllocator(Settings settings, ClusterSettings clusterSettings) {
        this.setWeightFunction(INDEX_BALANCE_FACTOR_SETTING.get(settings).floatValue(), SHARD_BALANCE_FACTOR_SETTING.get(settings).floatValue());
        this.setThreshold(THRESHOLD_SETTING.get(settings).floatValue());
        this.setPreferPrimaryShardBalance(PREFER_PRIMARY_SHARD_BALANCE.get(settings));
        this.setShardMovementStrategy(SHARD_MOVEMENT_STRATEGY_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(PREFER_PRIMARY_SHARD_BALANCE, this::setPreferPrimaryShardBalance);
        clusterSettings.addSettingsUpdateConsumer(SHARD_MOVE_PRIMARY_FIRST_SETTING, this::setMovePrimaryFirst);
        clusterSettings.addSettingsUpdateConsumer(SHARD_MOVEMENT_STRATEGY_SETTING, this::setShardMovementStrategy);
        clusterSettings.addSettingsUpdateConsumer(INDEX_BALANCE_FACTOR_SETTING, SHARD_BALANCE_FACTOR_SETTING, this::setWeightFunction);
        clusterSettings.addSettingsUpdateConsumer(THRESHOLD_SETTING, this::setThreshold);
    }

    private void setMovePrimaryFirst(boolean movePrimaryFirst) {
        this.movePrimaryFirst = movePrimaryFirst;
        this.setShardMovementStrategy(this.shardMovementStrategy);
    }

    private void setShardMovementStrategy(ShardMovementStrategy shardMovementStrategy) {
        this.shardMovementStrategy = shardMovementStrategy;
        if (shardMovementStrategy == ShardMovementStrategy.NO_PREFERENCE && this.movePrimaryFirst) {
            this.shardMovementStrategy = ShardMovementStrategy.PRIMARY_FIRST;
        }
    }

    private void setWeightFunction(float indexBalance, float shardBalanceFactor) {
        this.weightFunction = new WeightFunction(indexBalance, shardBalanceFactor);
    }

    private void setPreferPrimaryShardBalance(boolean preferPrimaryShardBalance) {
        this.preferPrimaryShardBalance = preferPrimaryShardBalance;
        this.weightFunction.updateAllocationConstraint("index.primary.shard.balance.constraint", preferPrimaryShardBalance);
        this.weightFunction.updateAllocationConstraint("cluster.primary.shard.balance.constraint", preferPrimaryShardBalance);
        this.weightFunction.updateRebalanceConstraint("index.primary.shard.balance.constraint", preferPrimaryShardBalance);
    }

    private void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    @Override
    public void allocate(RoutingAllocation allocation) {
        if (allocation.routingNodes().size() == 0) {
            this.failAllocationOfNewPrimaries(allocation);
            return;
        }
        LocalShardsBalancer localShardsBalancer = new LocalShardsBalancer(logger, allocation, this.shardMovementStrategy, this.weightFunction, this.threshold, this.preferPrimaryShardBalance);
        ((ShardsBalancer)localShardsBalancer).allocateUnassigned();
        ((ShardsBalancer)localShardsBalancer).moveShards();
        ((ShardsBalancer)localShardsBalancer).balance();
        RemoteShardsBalancer remoteShardsBalancer = new RemoteShardsBalancer(logger, allocation);
        ((ShardsBalancer)remoteShardsBalancer).allocateUnassigned();
        ((ShardsBalancer)remoteShardsBalancer).moveShards();
        ((ShardsBalancer)remoteShardsBalancer).balance();
    }

    @Override
    public ShardAllocationDecision decideShardAllocation(ShardRouting shard, RoutingAllocation allocation) {
        LocalShardsBalancer localShardsBalancer = new LocalShardsBalancer(logger, allocation, this.shardMovementStrategy, this.weightFunction, this.threshold, this.preferPrimaryShardBalance);
        AllocateUnassignedDecision allocateUnassignedDecision = AllocateUnassignedDecision.NOT_TAKEN;
        MoveDecision moveDecision = MoveDecision.NOT_TAKEN;
        if (shard.unassigned()) {
            allocateUnassignedDecision = ((ShardsBalancer)localShardsBalancer).decideAllocateUnassigned(shard);
        } else {
            moveDecision = ((ShardsBalancer)localShardsBalancer).decideMove(shard);
            if (moveDecision.isDecisionTaken() && moveDecision.canRemain()) {
                MoveDecision rebalanceDecision = ((ShardsBalancer)localShardsBalancer).decideRebalance(shard);
                moveDecision = rebalanceDecision.withRemainDecision(moveDecision.getCanRemainDecision());
            }
        }
        return new ShardAllocationDecision(allocateUnassignedDecision, moveDecision);
    }

    private void failAllocationOfNewPrimaries(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        assert (routingNodes.size() == 0) : routingNodes;
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shardRouting = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (!shardRouting.primary() || unassignedInfo.getLastAllocationStatus() != UnassignedInfo.AllocationStatus.NO_ATTEMPT) continue;
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.getReason(), unassignedInfo.getMessage(), unassignedInfo.getFailure(), unassignedInfo.getNumFailedAllocations(), unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), unassignedInfo.isDelayed(), UnassignedInfo.AllocationStatus.DECIDERS_NO, unassignedInfo.getFailedNodeIds()), shardRouting.recoverySource(), allocation.changes());
        }
    }

    public float getThreshold() {
        return this.threshold;
    }

    public float getIndexBalance() {
        return this.weightFunction.indexBalance;
    }

    public float getShardBalance() {
        return this.weightFunction.shardBalance;
    }

    public boolean getPreferPrimaryBalance() {
        return this.preferPrimaryShardBalance;
    }

    static class WeightFunction {
        private final float indexBalance;
        private final float shardBalance;
        private final float theta0;
        private final float theta1;
        private AllocationConstraints constraints;
        private RebalanceConstraints rebalanceConstraints;

        WeightFunction(float indexBalance, float shardBalance) {
            float sum = indexBalance + shardBalance;
            if (sum <= 0.0f) {
                throw new IllegalArgumentException("Balance factors must sum to a value > 0 but was: " + sum);
            }
            this.theta0 = shardBalance / sum;
            this.theta1 = indexBalance / sum;
            this.indexBalance = indexBalance;
            this.shardBalance = shardBalance;
            this.constraints = new AllocationConstraints();
            this.rebalanceConstraints = new RebalanceConstraints();
            this.updateAllocationConstraint("index.shard.count.constraint", true);
        }

        public float weightWithAllocationConstraints(ShardsBalancer balancer, ModelNode node, String index) {
            float balancerWeight = this.weight(balancer, node, index);
            return balancerWeight + (float)this.constraints.weight(balancer, node, index);
        }

        public float weightWithRebalanceConstraints(ShardsBalancer balancer, ModelNode node, String index) {
            float balancerWeight = this.weight(balancer, node, index);
            return balancerWeight + (float)this.rebalanceConstraints.weight(balancer, node, index);
        }

        float weight(ShardsBalancer balancer, ModelNode node, String index) {
            float weightShard = (float)node.numShards() - balancer.avgShardsPerNode();
            float weightIndex = (float)node.numShards(index) - balancer.avgShardsPerNode(index);
            return this.theta0 * weightShard + this.theta1 * weightIndex;
        }

        void updateAllocationConstraint(String constraint, boolean enable) {
            this.constraints.updateAllocationConstraint(constraint, enable);
        }

        void updateRebalanceConstraint(String constraint, boolean add) {
            this.rebalanceConstraints.updateRebalanceConstraint(constraint, add);
        }
    }

    static final class NodeSorter
    extends IntroSorter {
        final ModelNode[] modelNodes;
        final float[] weights;
        private final WeightFunction function;
        private String index;
        private final ShardsBalancer balancer;
        private float pivotWeight;

        NodeSorter(ModelNode[] modelNodes, WeightFunction function, ShardsBalancer balancer) {
            this.function = function;
            this.balancer = balancer;
            this.modelNodes = modelNodes;
            this.weights = new float[modelNodes.length];
        }

        public void reset(String index, int from, int to) {
            this.index = index;
            for (int i = from; i < to; ++i) {
                this.weights[i] = this.weight(this.modelNodes[i]);
            }
            this.sort(from, to);
        }

        public void reset(String index) {
            this.reset(index, 0, this.modelNodes.length);
        }

        public float weight(ModelNode node) {
            return this.function.weightWithRebalanceConstraints(this.balancer, node, this.index);
        }

        @Override
        protected void swap(int i, int j) {
            ModelNode tmpNode = this.modelNodes[i];
            this.modelNodes[i] = this.modelNodes[j];
            this.modelNodes[j] = tmpNode;
            float tmpWeight = this.weights[i];
            this.weights[i] = this.weights[j];
            this.weights[j] = tmpWeight;
        }

        @Override
        protected int compare(int i, int j) {
            return Float.compare(this.weights[i], this.weights[j]);
        }

        @Override
        protected void setPivot(int i) {
            this.pivotWeight = this.weights[i];
        }

        @Override
        protected int comparePivot(int j) {
            return Float.compare(this.pivotWeight, this.weights[j]);
        }

        public float delta() {
            return this.weights[this.weights.length - 1] - this.weights[0];
        }
    }

    static final class ModelIndex
    implements Iterable<ShardRouting> {
        private final String id;
        private final Set<ShardRouting> shards = new HashSet<ShardRouting>(4);
        private final Set<ShardRouting> primaryShards = new HashSet<ShardRouting>();
        private int highestPrimary = -1;

        ModelIndex(String id) {
            this.id = id;
        }

        public int numPrimaryShards() {
            return this.primaryShards.size();
        }

        public int highestPrimary() {
            if (this.highestPrimary == -1) {
                int maxId = -1;
                for (ShardRouting shard : this.shards) {
                    if (!shard.primary()) continue;
                    maxId = Math.max(maxId, shard.id());
                }
                this.highestPrimary = maxId;
                return this.highestPrimary;
            }
            return this.highestPrimary;
        }

        public String getIndexId() {
            return this.id;
        }

        public int numShards() {
            return this.shards.size();
        }

        @Override
        public Iterator<ShardRouting> iterator() {
            return this.shards.iterator();
        }

        public void removeShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (this.shards.contains(shard)) : "Shard not allocated on current node: " + shard;
            if (shard.primary()) {
                assert (this.primaryShards.contains(shard)) : "Primary shard not allocated on current node: " + shard;
                this.primaryShards.remove(shard);
            }
            this.shards.remove(shard);
        }

        public void addShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (!this.shards.contains(shard)) : "Shard already allocated on current node: " + shard;
            if (shard.primary()) {
                assert (!this.primaryShards.contains(shard)) : "Primary shard already allocated on current node: " + shard;
                this.primaryShards.add(shard);
            }
            this.shards.add(shard);
        }

        public boolean containsShard(ShardRouting shard) {
            return this.shards.contains(shard);
        }
    }

    @Deprecated
    public static class Balancer
    extends LocalShardsBalancer {
        public Balancer(Logger logger, RoutingAllocation allocation, ShardMovementStrategy shardMovementStrategy, WeightFunction weight, float threshold, boolean preferPrimaryBalance) {
            super(logger, allocation, shardMovementStrategy, weight, threshold, preferPrimaryBalance);
        }
    }

    public static class ModelNode
    implements Iterable<ModelIndex> {
        private final Map<String, ModelIndex> indices = new HashMap<String, ModelIndex>();
        private int numShards = 0;
        private final RoutingNode routingNode;

        ModelNode(RoutingNode routingNode) {
            this.routingNode = routingNode;
        }

        public ModelIndex getIndex(String indexId) {
            return this.indices.get(indexId);
        }

        public String getNodeId() {
            return this.routingNode.nodeId();
        }

        public RoutingNode getRoutingNode() {
            return this.routingNode;
        }

        public int numShards() {
            return this.numShards;
        }

        public int numShards(String idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numShards();
        }

        public int numPrimaryShards(String idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numPrimaryShards();
        }

        public int numPrimaryShards() {
            return this.indices.values().stream().mapToInt(index -> index.numPrimaryShards()).sum();
        }

        public int highestPrimary(String index) {
            ModelIndex idx = this.indices.get(index);
            if (idx != null) {
                return idx.highestPrimary();
            }
            return -1;
        }

        public void addShard(ShardRouting shard) {
            ModelIndex index = this.indices.get(shard.getIndexName());
            if (index == null) {
                index = new ModelIndex(shard.getIndexName());
                this.indices.put(index.getIndexId(), index);
            }
            index.addShard(shard);
            ++this.numShards;
        }

        public void removeShard(ShardRouting shard) {
            ModelIndex index = this.indices.get(shard.getIndexName());
            if (index != null) {
                index.removeShard(shard);
                if (index.numShards() == 0) {
                    this.indices.remove(shard.getIndexName());
                }
            }
            --this.numShards;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(").append(this.routingNode.nodeId()).append(")");
            return sb.toString();
        }

        @Override
        public Iterator<ModelIndex> iterator() {
            return this.indices.values().iterator();
        }

        public boolean containsShard(ShardRouting shard) {
            ModelIndex index = this.getIndex(shard.getIndexName());
            return index == null ? false : index.containsShard(shard);
        }
    }
}

