/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationState;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;

public class PersistedStateRegistry
implements Closeable {
    private final Map<PersistedStateType, CoordinationState.PersistedState> persistedStates = new ConcurrentHashMap<PersistedStateType, CoordinationState.PersistedState>();

    public void addPersistedState(PersistedStateType persistedStateType, CoordinationState.PersistedState persistedState) {
        CoordinationState.PersistedState existingState = this.persistedStates.putIfAbsent(persistedStateType, persistedState);
        assert (existingState == null) : "should only be set once, but already have " + existingState;
    }

    public CoordinationState.PersistedState getPersistedState(PersistedStateType persistedStateType) {
        return this.persistedStates.get((Object)persistedStateType);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.persistedStates.values());
    }

    public static enum PersistedStateType {
        LOCAL,
        REMOTE;

    }
}

