/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client.cluster;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.client.cluster.ProxyModeInfo;
import org.graylog.shaded.opensearch2.org.opensearch.client.cluster.SniffModeInfo;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public final class RemoteConnectionInfo {
    private static final String CONNECTED = "connected";
    private static final String MODE = "mode";
    private static final String INITIAL_CONNECT_TIMEOUT = "initial_connect_timeout";
    private static final String SKIP_UNAVAILABLE = "skip_unavailable";
    private static final ConstructingObjectParser<RemoteConnectionInfo, String> PARSER = new ConstructingObjectParser<RemoteConnectionInfo, String>("RemoteConnectionInfoObjectParser", false, (args, clusterAlias) -> {
        ModeInfo modeInfo;
        String mode = (String)args[1];
        if (mode.equals("proxy")) {
            modeInfo = new ProxyModeInfo((String)args[4], (String)args[5], (Integer)args[6], (Integer)args[7]);
        } else if (mode.equals("sniff")) {
            modeInfo = new SniffModeInfo((List)args[8], (Integer)args[9], (Integer)args[10]);
        } else {
            throw new IllegalArgumentException("mode cannot be " + mode);
        }
        return new RemoteConnectionInfo((String)clusterAlias, modeInfo, (String)args[2], (Boolean)args[3]);
    });
    private final ModeInfo modeInfo;
    private final String initialConnectionTimeoutString;
    private final String clusterAlias;
    private final boolean skipUnavailable;

    RemoteConnectionInfo(String clusterAlias, ModeInfo modeInfo, String initialConnectionTimeoutString, boolean skipUnavailable) {
        this.clusterAlias = clusterAlias;
        this.modeInfo = modeInfo;
        this.initialConnectionTimeoutString = initialConnectionTimeoutString;
        this.skipUnavailable = skipUnavailable;
    }

    public boolean isConnected() {
        return this.modeInfo.isConnected();
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ModeInfo getModeInfo() {
        return this.modeInfo;
    }

    public String getInitialConnectionTimeoutString() {
        return this.initialConnectionTimeoutString;
    }

    public boolean isSkipUnavailable() {
        return this.skipUnavailable;
    }

    public static RemoteConnectionInfo fromXContent(XContentParser parser, String clusterAlias) throws IOException {
        return PARSER.parse(parser, clusterAlias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConnectionInfo that = (RemoteConnectionInfo)o;
        return this.skipUnavailable == that.skipUnavailable && Objects.equals(this.modeInfo, that.modeInfo) && Objects.equals(this.initialConnectionTimeoutString, that.initialConnectionTimeoutString) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.modeInfo, this.initialConnectionTimeoutString, this.clusterAlias, this.skipUnavailable);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(CONNECTED, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(MODE, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(INITIAL_CONNECT_TIMEOUT, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(SKIP_UNAVAILABLE, new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("proxy_address", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("server_name", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_proxy_socket_connections", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("num_proxy_sockets_connected", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), new ParseField("seeds", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("max_connections_per_cluster", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("num_nodes_connected", new String[0]));
    }

    public static interface ModeInfo {
        public boolean isConnected();

        public String modeName();
    }
}

