/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.io.IOException;
import java.util.Collections;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DeleteSearchPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.GetSearchPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.GetSearchPipelineResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.PutSearchPipelineRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.Cancellable;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestHighLevelClient;
import org.graylog.shaded.opensearch2.org.opensearch.client.SearchPipelineRequestConverters;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;

public final class SearchPipelineClient {
    private final RestHighLevelClient restHighLevelClient;

    SearchPipelineClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse put(PutSearchPipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SearchPipelineRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putAsync(PutSearchPipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SearchPipelineRequestConverters::putPipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSearchPipelineResponse get(GetSearchPipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SearchPipelineRequestConverters::getPipeline, options, GetSearchPipelineResponse::fromXContent, Collections.singleton(404));
    }

    public Cancellable getAsync(GetSearchPipelineRequest request, RequestOptions options, ActionListener<GetSearchPipelineResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SearchPipelineRequestConverters::getPipeline, options, GetSearchPipelineResponse::fromXContent, listener, Collections.singleton(404));
    }

    public AcknowledgedResponse delete(DeleteSearchPipelineRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SearchPipelineRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteAsync(DeleteSearchPipelineRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SearchPipelineRequestConverters::deletePipeline, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }
}

