/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLHandshakeException;
import org.graylog.shaded.opensearch2.org.apache.commons.logging.Log;
import org.graylog.shaded.opensearch2.org.apache.commons.logging.LogFactory;
import org.graylog.shaded.opensearch2.org.apache.http.ConnectionClosedException;
import org.graylog.shaded.opensearch2.org.apache.http.Header;
import org.graylog.shaded.opensearch2.org.apache.http.HttpEntity;
import org.graylog.shaded.opensearch2.org.apache.http.HttpHost;
import org.graylog.shaded.opensearch2.org.apache.http.HttpRequest;
import org.graylog.shaded.opensearch2.org.apache.http.HttpResponse;
import org.graylog.shaded.opensearch2.org.apache.http.NameValuePair;
import org.graylog.shaded.opensearch2.org.apache.http.client.AuthCache;
import org.graylog.shaded.opensearch2.org.apache.http.client.config.RequestConfig;
import org.graylog.shaded.opensearch2.org.apache.http.client.entity.GzipCompressingEntity;
import org.graylog.shaded.opensearch2.org.apache.http.client.entity.GzipDecompressingEntity;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpHead;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpOptions;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpPatch;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpPost;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpPut;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpRequestBase;
import org.graylog.shaded.opensearch2.org.apache.http.client.methods.HttpTrace;
import org.graylog.shaded.opensearch2.org.apache.http.client.protocol.HttpClientContext;
import org.graylog.shaded.opensearch2.org.apache.http.client.utils.URIBuilder;
import org.graylog.shaded.opensearch2.org.apache.http.concurrent.FutureCallback;
import org.graylog.shaded.opensearch2.org.apache.http.conn.ConnectTimeoutException;
import org.graylog.shaded.opensearch2.org.apache.http.entity.HttpEntityWrapper;
import org.graylog.shaded.opensearch2.org.apache.http.impl.auth.BasicScheme;
import org.graylog.shaded.opensearch2.org.apache.http.impl.client.BasicAuthCache;
import org.graylog.shaded.opensearch2.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.graylog.shaded.opensearch2.org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.graylog.shaded.opensearch2.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.graylog.shaded.opensearch2.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.graylog.shaded.opensearch2.org.apache.http.protocol.HttpContext;
import org.graylog.shaded.opensearch2.org.opensearch.client.Cancellable;
import org.graylog.shaded.opensearch2.org.opensearch.client.DeadHostState;
import org.graylog.shaded.opensearch2.org.opensearch.client.HttpDeleteWithEntity;
import org.graylog.shaded.opensearch2.org.opensearch.client.HttpGetWithEntity;
import org.graylog.shaded.opensearch2.org.opensearch.client.Node;
import org.graylog.shaded.opensearch2.org.opensearch.client.NodeSelector;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestLogger;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.shaded.opensearch2.org.opensearch.client.ResponseException;
import org.graylog.shaded.opensearch2.org.opensearch.client.ResponseListener;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestClientBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.client.WarningFailureException;
import org.graylog.shaded.opensearch2.org.opensearch.client.WarningsHandler;

public class RestClient
implements Closeable {
    private static final Log logger = LogFactory.getLog(RestClient.class);
    private final CloseableHttpAsyncClient client;
    final List<Header> defaultHeaders;
    private final String pathPrefix;
    private final AtomicInteger lastNodeIndex = new AtomicInteger(0);
    private final ConcurrentMap<HttpHost, DeadHostState> denylist = new ConcurrentHashMap<HttpHost, DeadHostState>();
    private final FailureListener failureListener;
    private final NodeSelector nodeSelector;
    private volatile NodeTuple<List<Node>> nodeTuple;
    private final WarningsHandler warningsHandler;
    private final boolean compressionEnabled;
    private final Optional<Boolean> chunkedEnabled;

    RestClient(CloseableHttpAsyncClient client, Header[] defaultHeaders, List<Node> nodes, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode, boolean compressionEnabled, boolean chunkedEnabled) {
        this.client = client;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.failureListener = failureListener;
        this.pathPrefix = pathPrefix;
        this.nodeSelector = nodeSelector;
        this.warningsHandler = strictDeprecationMode ? WarningsHandler.STRICT : WarningsHandler.PERMISSIVE;
        this.compressionEnabled = compressionEnabled;
        this.chunkedEnabled = Optional.of(chunkedEnabled);
        this.setNodes(nodes);
    }

    RestClient(CloseableHttpAsyncClient client, Header[] defaultHeaders, List<Node> nodes, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode, boolean compressionEnabled) {
        this.client = client;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.failureListener = failureListener;
        this.pathPrefix = pathPrefix;
        this.nodeSelector = nodeSelector;
        this.warningsHandler = strictDeprecationMode ? WarningsHandler.STRICT : WarningsHandler.PERMISSIVE;
        this.compressionEnabled = compressionEnabled;
        this.chunkedEnabled = Optional.empty();
        this.setNodes(nodes);
    }

    public static RestClientBuilder builder(String cloudId) {
        int port;
        String decoded;
        String[] decodedParts;
        if (cloudId.contains(":")) {
            if (cloudId.indexOf(":") == cloudId.length() - 1) {
                throw new IllegalStateException("cloudId " + cloudId + " must begin with a human readable identifier followed by a colon");
            }
            cloudId = cloudId.substring(cloudId.indexOf(":") + 1);
        }
        if ((decodedParts = (decoded = new String(Base64.getDecoder().decode(cloudId), StandardCharsets.UTF_8)).split("\\$")).length != 3) {
            throw new IllegalStateException("cloudId " + cloudId + " did not decode to a cluster identifier correctly");
        }
        String[] domainAndMaybePort = decodedParts[0].split(":", 2);
        String domain = domainAndMaybePort[0];
        if (domainAndMaybePort.length == 2) {
            try {
                port = Integer.parseInt(domainAndMaybePort[1]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("cloudId " + cloudId + " does not contain a valid port number");
            }
        } else {
            port = 443;
        }
        String url = decodedParts[1] + "." + domain;
        return RestClient.builder(new HttpHost(url, port, "https"));
    }

    public static RestClientBuilder builder(Node ... nodes) {
        return new RestClientBuilder(nodes == null ? null : Arrays.asList(nodes));
    }

    public static RestClientBuilder builder(HttpHost ... hosts) {
        if (hosts == null || hosts.length == 0) {
            throw new IllegalArgumentException("hosts must not be null nor empty");
        }
        List<Node> nodes = Arrays.stream(hosts).map(Node::new).collect(Collectors.toList());
        return new RestClientBuilder(nodes);
    }

    public synchronized void setNodes(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        BasicAuthCache authCache = new BasicAuthCache();
        LinkedHashMap<HttpHost, Node> nodesByHost = new LinkedHashMap<HttpHost, Node>();
        for (Node node : nodes) {
            Objects.requireNonNull(node, "node cannot be null");
            nodesByHost.put(node.getHost(), node);
            authCache.put(node.getHost(), new BasicScheme());
        }
        this.nodeTuple = new NodeTuple(Collections.unmodifiableList(new ArrayList(nodesByHost.values())), authCache);
        this.denylist.clear();
    }

    public List<Node> getNodes() {
        return (List)this.nodeTuple.nodes;
    }

    public boolean isRunning() {
        return this.client.isRunning();
    }

    public Response performRequest(Request request) throws IOException {
        InternalRequest internalRequest = new InternalRequest(request);
        return this.performRequest(this.nextNodes(), internalRequest, null);
    }

    private Response performRequest(NodeTuple<Iterator<Node>> nodeTuple, InternalRequest request, Exception previousException) throws IOException {
        HttpResponse httpResponse;
        RequestContext context = request.createContextForNextAttempt((Node)((Iterator)nodeTuple.nodes).next(), nodeTuple.authCache);
        try {
            httpResponse = this.client.execute(context.requestProducer, context.asyncResponseConsumer, (HttpContext)context.context, null).get();
        }
        catch (Exception e) {
            RequestLogger.logFailedRequest(logger, request.httpRequest, context.node, e);
            this.onFailure(context.node);
            Exception cause = RestClient.extractAndWrapCause(e);
            RestClient.addSuppressedException(previousException, cause);
            if (((Iterator)nodeTuple.nodes).hasNext()) {
                return this.performRequest(nodeTuple, request, cause);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("unexpected exception type: must be either RuntimeException or IOException", cause);
        }
        ResponseOrResponseException responseOrResponseException = this.convertResponse(request, context.node, httpResponse);
        if (responseOrResponseException.responseException == null) {
            return responseOrResponseException.response;
        }
        RestClient.addSuppressedException(previousException, responseOrResponseException.responseException);
        if (((Iterator)nodeTuple.nodes).hasNext()) {
            return this.performRequest(nodeTuple, request, responseOrResponseException.responseException);
        }
        throw responseOrResponseException.responseException;
    }

    private ResponseOrResponseException convertResponse(InternalRequest request, Node node, HttpResponse httpResponse) throws IOException {
        RequestLogger.logResponse(logger, request.httpRequest, node.getHost(), httpResponse);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        Optional.ofNullable(httpResponse.getEntity()).map(HttpEntity::getContentEncoding).map(NameValuePair::getValue).filter("gzip"::equalsIgnoreCase).map(gzipHeaderValue -> new GzipDecompressingEntity(httpResponse.getEntity())).ifPresent(httpResponse::setEntity);
        Response response = new Response(request.httpRequest.getRequestLine(), node.getHost(), httpResponse);
        if (RestClient.isSuccessfulResponse(statusCode) || request.ignoreErrorCodes.contains(response.getStatusLine().getStatusCode())) {
            this.onResponse(node);
            if (request.warningsHandler.warningsShouldFailRequest(response.getWarnings())) {
                throw new WarningFailureException(response);
            }
            return new ResponseOrResponseException(response);
        }
        ResponseException responseException = new ResponseException(response);
        if (RestClient.isRetryStatus(statusCode)) {
            this.onFailure(node);
            return new ResponseOrResponseException(responseException);
        }
        this.onResponse(node);
        throw responseException;
    }

    public Cancellable performRequestAsync(Request request, ResponseListener responseListener) {
        try {
            FailureTrackingResponseListener failureTrackingResponseListener = new FailureTrackingResponseListener(responseListener);
            InternalRequest internalRequest = new InternalRequest(request);
            this.performRequestAsync(this.nextNodes(), internalRequest, failureTrackingResponseListener);
            return internalRequest.cancellable;
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return Cancellable.NO_OP;
        }
    }

    private void performRequestAsync(final NodeTuple<Iterator<Node>> nodeTuple, final InternalRequest request, final FailureTrackingResponseListener listener) {
        request.cancellable.runIfNotCancelled(() -> {
            final RequestContext context = request.createContextForNextAttempt((Node)((Iterator)nodeTuple.nodes).next(), nodeTuple.authCache);
            this.client.execute(context.requestProducer, context.asyncResponseConsumer, (HttpContext)context.context, new FutureCallback<HttpResponse>(){

                @Override
                public void completed(HttpResponse httpResponse) {
                    try {
                        ResponseOrResponseException responseOrResponseException = RestClient.this.convertResponse(request, context.node, httpResponse);
                        if (responseOrResponseException.responseException == null) {
                            listener.onSuccess(responseOrResponseException.response);
                        } else if (((Iterator)nodeTuple.nodes).hasNext()) {
                            listener.trackFailure(responseOrResponseException.responseException);
                            RestClient.this.performRequestAsync(nodeTuple, request, listener);
                        } else {
                            listener.onDefinitiveFailure(responseOrResponseException.responseException);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                @Override
                public void failed(Exception failure) {
                    try {
                        RequestLogger.logFailedRequest(logger, request.httpRequest, context.node, failure);
                        RestClient.this.onFailure(context.node);
                        if (((Iterator)nodeTuple.nodes).hasNext()) {
                            listener.trackFailure(failure);
                            RestClient.this.performRequestAsync(nodeTuple, request, listener);
                        } else {
                            listener.onDefinitiveFailure(failure);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                @Override
                public void cancelled() {
                    listener.onDefinitiveFailure(Cancellable.newCancellationException());
                }
            });
        });
    }

    private NodeTuple<Iterator<Node>> nextNodes() throws IOException {
        NodeTuple<List<Node>> nodeTuple = this.nodeTuple;
        Iterable<Node> hosts = RestClient.selectNodes(nodeTuple, this.denylist, this.lastNodeIndex, this.nodeSelector);
        return new NodeTuple<Iterator<Node>>(hosts.iterator(), nodeTuple.authCache);
    }

    static Iterable<Node> selectNodes(NodeTuple<List<Node>> nodeTuple, Map<HttpHost, DeadHostState> denylist, AtomicInteger lastNodeIndex, NodeSelector nodeSelector) throws IOException {
        ArrayList<Node> livingNodes = new ArrayList<Node>(Math.max(0, ((List)nodeTuple.nodes).size() - denylist.size()));
        ArrayList<DeadNode> deadNodes = new ArrayList<DeadNode>(denylist.size());
        for (Node node : (List)nodeTuple.nodes) {
            DeadHostState deadness = denylist.get(node.getHost());
            if (deadness == null || deadness.shallBeRetried()) {
                livingNodes.add(node);
                continue;
            }
            deadNodes.add(new DeadNode(node, deadness));
        }
        if (!livingNodes.isEmpty()) {
            ArrayList<Node> selectedLivingNodes = new ArrayList<Node>(livingNodes);
            nodeSelector.select(selectedLivingNodes);
            if (!selectedLivingNodes.isEmpty()) {
                Collections.rotate(selectedLivingNodes, lastNodeIndex.getAndIncrement());
                return selectedLivingNodes;
            }
        }
        if (!deadNodes.isEmpty()) {
            ArrayList selectedDeadNodes = new ArrayList(deadNodes);
            nodeSelector.select(() -> new DeadNodeIteratorAdapter(selectedDeadNodes.iterator()));
            if (!selectedDeadNodes.isEmpty()) {
                return Collections.singletonList(((DeadNode)Collections.min(selectedDeadNodes)).node);
            }
        }
        throw new IOException("NodeSelector [" + nodeSelector + "] rejected all nodes, living " + livingNodes + " and dead " + deadNodes);
    }

    private void onResponse(Node node) {
        DeadHostState removedHost = (DeadHostState)this.denylist.remove(node.getHost());
        if (logger.isDebugEnabled() && removedHost != null) {
            logger.debug("removed [" + node + "] from denylist");
        }
    }

    private void onFailure(Node node) {
        block3: {
            DeadHostState previousDeadHostState;
            do {
                if ((previousDeadHostState = this.denylist.putIfAbsent(node.getHost(), new DeadHostState(DeadHostState.DEFAULT_TIME_SUPPLIER))) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("added [" + node + "] to denylist");
                }
                break block3;
            } while (!this.denylist.replace(node.getHost(), previousDeadHostState, new DeadHostState(previousDeadHostState)));
            if (logger.isDebugEnabled()) {
                logger.debug("updated [" + node + "] already in denylist");
            }
        }
        this.failureListener.onFailure(node);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static boolean isSuccessfulResponse(int statusCode) {
        return statusCode < 300;
    }

    private static boolean isRetryStatus(int statusCode) {
        switch (statusCode) {
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static void addSuppressedException(Exception suppressedException, Exception currentException) {
        if (suppressedException != null) {
            currentException.addSuppressed(suppressedException);
        }
    }

    private HttpRequestBase createHttpRequest(String method, URI uri, HttpEntity entity) {
        switch (method.toUpperCase(Locale.ROOT)) {
            case "DELETE": {
                return this.addRequestBody(new HttpDeleteWithEntity(uri), entity);
            }
            case "GET": {
                return this.addRequestBody(new HttpGetWithEntity(uri), entity);
            }
            case "HEAD": {
                return this.addRequestBody(new HttpHead(uri), entity);
            }
            case "OPTIONS": {
                return this.addRequestBody(new HttpOptions(uri), entity);
            }
            case "PATCH": {
                return this.addRequestBody(new HttpPatch(uri), entity);
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(uri);
                this.addRequestBody(httpPost, entity);
                return httpPost;
            }
            case "PUT": {
                return this.addRequestBody(new HttpPut(uri), entity);
            }
            case "TRACE": {
                return this.addRequestBody(new HttpTrace(uri), entity);
            }
        }
        throw new UnsupportedOperationException("http method not supported: " + method);
    }

    private HttpRequestBase addRequestBody(HttpRequestBase httpRequest, HttpEntity entity) {
        if (entity != null) {
            if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
                if (this.compressionEnabled) {
                    entity = this.chunkedEnabled.isPresent() ? new ContentCompressingEntity(entity, this.chunkedEnabled.get()) : new ContentCompressingEntity(entity);
                } else if (this.chunkedEnabled.isPresent()) {
                    entity = new ContentHttpEntity(entity, this.chunkedEnabled.get());
                }
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
            } else {
                throw new UnsupportedOperationException(httpRequest.getMethod() + " with body is not supported");
            }
        }
        return httpRequest;
    }

    static URI buildUri(String pathPrefix, String path, Map<String, String> params) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            Object fullPath = pathPrefix != null && !pathPrefix.isEmpty() ? (pathPrefix.endsWith("/") && path.startsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) + path : (pathPrefix.endsWith("/") || path.startsWith("/") ? pathPrefix + path : pathPrefix + "/" + path)) : path;
            URIBuilder uriBuilder = new URIBuilder((String)fullPath);
            for (Map.Entry<String, String> param : params.entrySet()) {
                uriBuilder.addParameter(param.getKey(), param.getValue());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static Set<Integer> getIgnoreErrorCodes(String ignoreString, String requestMethod) {
        Set<Integer> ignoreErrorCodes;
        if (ignoreString == null) {
            ignoreErrorCodes = "HEAD".equals(requestMethod) ? Collections.singleton(404) : Collections.emptySet();
        } else {
            String[] ignoresArray = ignoreString.split(",");
            ignoreErrorCodes = new HashSet();
            if ("HEAD".equals(requestMethod)) {
                ignoreErrorCodes.add(404);
            }
            for (String ignoreCode : ignoresArray) {
                try {
                    ignoreErrorCodes.add(Integer.valueOf(ignoreCode));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("ignore value should be a number, found [" + ignoreString + "] instead", e);
                }
            }
        }
        return ignoreErrorCodes;
    }

    private static Exception extractAndWrapCause(Exception exception) {
        IOException e;
        if (exception instanceof InterruptedException) {
            throw new RuntimeException("thread waiting for the response was interrupted", exception);
        }
        if (exception instanceof ExecutionException) {
            Throwable t;
            ExecutionException executionException = (ExecutionException)exception;
            Throwable throwable = t = executionException.getCause() == null ? executionException : executionException.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            exception = t;
        }
        if (exception instanceof ConnectTimeoutException) {
            e = new ConnectTimeoutException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof SocketTimeoutException) {
            e = new SocketTimeoutException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof ConnectionClosedException) {
            e = new ConnectionClosedException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof SSLHandshakeException) {
            e = new SSLHandshakeException(exception.getMessage() + "\nSee https://opensearch.org/docs/latest/clients/java-rest-high-level/ for troubleshooting.");
            e.initCause(exception);
            return e;
        }
        if (exception instanceof ConnectException) {
            e = new ConnectException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof IOException) {
            return new IOException(exception.getMessage(), exception);
        }
        if (exception instanceof RuntimeException) {
            return new RuntimeException(exception.getMessage(), exception);
        }
        return new RuntimeException("error while performing request", exception);
    }

    public static class FailureListener {
        public void onFailure(Node node) {
        }
    }

    static class NodeTuple<T> {
        final T nodes;
        final AuthCache authCache;

        NodeTuple(T nodes, AuthCache authCache) {
            this.nodes = nodes;
            this.authCache = authCache;
        }
    }

    private class InternalRequest {
        private final Request request;
        private final Set<Integer> ignoreErrorCodes;
        private final HttpRequestBase httpRequest;
        private final Cancellable cancellable;
        private final WarningsHandler warningsHandler;

        InternalRequest(Request request) {
            this.request = request;
            HashMap<String, String> params = new HashMap<String, String>(request.getParameters());
            String ignoreString = (String)params.remove("ignore");
            this.ignoreErrorCodes = RestClient.getIgnoreErrorCodes(ignoreString, request.getMethod());
            URI uri = RestClient.buildUri(RestClient.this.pathPrefix, request.getEndpoint(), params);
            this.httpRequest = RestClient.this.createHttpRequest(request.getMethod(), uri, request.getEntity());
            this.cancellable = Cancellable.fromRequest(this.httpRequest);
            this.setHeaders(this.httpRequest, request.getOptions().getHeaders());
            this.setRequestConfig(this.httpRequest, request.getOptions().getRequestConfig());
            this.warningsHandler = request.getOptions().getWarningsHandler() == null ? RestClient.this.warningsHandler : request.getOptions().getWarningsHandler();
        }

        private void setHeaders(HttpRequest httpRequest, Collection<Header> requestHeaders) {
            HashSet<String> requestNames = new HashSet<String>(requestHeaders.size());
            for (Header requestHeader : requestHeaders) {
                httpRequest.addHeader(requestHeader);
                requestNames.add(requestHeader.getName());
            }
            for (Header defaultHeader : RestClient.this.defaultHeaders) {
                if (requestNames.contains(defaultHeader.getName())) continue;
                httpRequest.addHeader(defaultHeader);
            }
            if (RestClient.this.compressionEnabled) {
                httpRequest.addHeader("Accept-Encoding", "gzip");
            }
        }

        private void setRequestConfig(HttpRequestBase httpRequest, RequestConfig requestConfig) {
            if (requestConfig != null) {
                httpRequest.setConfig(requestConfig);
            }
        }

        RequestContext createContextForNextAttempt(Node node, AuthCache authCache) {
            this.httpRequest.reset();
            return new RequestContext(this, node, authCache);
        }
    }

    private static class RequestContext {
        private final Node node;
        private final HttpAsyncRequestProducer requestProducer;
        private final HttpAsyncResponseConsumer<HttpResponse> asyncResponseConsumer;
        private final HttpClientContext context;

        RequestContext(InternalRequest request, Node node, AuthCache authCache) {
            this.node = node;
            this.requestProducer = HttpAsyncMethods.create(node.getHost(), request.httpRequest);
            this.asyncResponseConsumer = request.request.getOptions().getHttpAsyncResponseConsumerFactory().createHttpAsyncResponseConsumer();
            this.context = HttpClientContext.create();
            this.context.setAuthCache(authCache);
        }
    }

    private static class ResponseOrResponseException {
        private final Response response;
        private final ResponseException responseException;

        ResponseOrResponseException(Response response) {
            this.response = Objects.requireNonNull(response);
            this.responseException = null;
        }

        ResponseOrResponseException(ResponseException responseException) {
            this.responseException = Objects.requireNonNull(responseException);
            this.response = null;
        }
    }

    static class FailureTrackingResponseListener {
        private final ResponseListener responseListener;
        private volatile Exception exception;

        FailureTrackingResponseListener(ResponseListener responseListener) {
            this.responseListener = responseListener;
        }

        void onSuccess(Response response) {
            this.responseListener.onSuccess(response);
        }

        void onDefinitiveFailure(Exception exception) {
            this.trackFailure(exception);
            this.responseListener.onFailure(this.exception);
        }

        void trackFailure(Exception exception) {
            RestClient.addSuppressedException(this.exception, exception);
            this.exception = exception;
        }
    }

    private static class DeadNode
    implements Comparable<DeadNode> {
        final Node node;
        final DeadHostState deadness;

        DeadNode(Node node, DeadHostState deadness) {
            this.node = node;
            this.deadness = deadness;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(DeadNode rhs) {
            return this.deadness.compareTo(rhs.deadness);
        }
    }

    public static class ContentCompressingEntity
    extends GzipCompressingEntity {
        private Optional<Boolean> chunkedEnabled;

        public ContentCompressingEntity(HttpEntity entity) {
            super(entity);
            this.chunkedEnabled = Optional.empty();
        }

        public ContentCompressingEntity(HttpEntity entity, boolean chunkedEnabled) {
            super(entity);
            this.chunkedEnabled = Optional.of(chunkedEnabled);
        }

        @Override
        public InputStream getContent() throws IOException {
            ByteArrayInputOutputStream out = new ByteArrayInputOutputStream(1024);
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(out);){
                this.wrappedEntity.writeTo(gzipOut);
            }
            return out.asInput();
        }

        @Override
        public boolean isChunked() {
            return this.chunkedEnabled.orElseGet(() -> super.isChunked());
        }

        @Override
        public long getContentLength() {
            if (this.chunkedEnabled.isPresent()) {
                long size;
                if (this.chunkedEnabled.get().booleanValue()) {
                    return -1L;
                }
                try (InputStream is = this.getContent();){
                    size = is.readAllBytes().length;
                }
                catch (IOException ex) {
                    size = -1L;
                }
                return size;
            }
            return super.getContentLength();
        }
    }

    public static class ContentHttpEntity
    extends HttpEntityWrapper {
        private Optional<Boolean> chunkedEnabled;

        public ContentHttpEntity(HttpEntity entity) {
            super(entity);
            this.chunkedEnabled = Optional.empty();
        }

        public ContentHttpEntity(HttpEntity entity, boolean chunkedEnabled) {
            super(entity);
            this.chunkedEnabled = Optional.of(chunkedEnabled);
        }

        @Override
        public boolean isChunked() {
            return this.chunkedEnabled.orElseGet(() -> super.isChunked());
        }
    }

    private static class DeadNodeIteratorAdapter
    implements Iterator<Node> {
        private final Iterator<DeadNode> itr;

        private DeadNodeIteratorAdapter(Iterator<DeadNode> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            return this.itr.next().node;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static class ByteArrayInputOutputStream
    extends ByteArrayOutputStream {
        ByteArrayInputOutputStream(int size) {
            super(size);
        }

        public InputStream asInput() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

