/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cli;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.joptsimple.OptionSet;
import org.graylog.shaded.opensearch2.org.opensearch.cli.EnvironmentAwareCommand;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.cli.UserException;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.KeyStoreWrapper;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.settings.SecureString;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;

public abstract class KeyStoreAwareCommand
extends EnvironmentAwareCommand {
    public static final int MAX_PASSPHRASE_LENGTH = 128;

    public KeyStoreAwareCommand(String description) {
        super(description);
    }

    protected static SecureString readPassword(Terminal terminal, boolean withVerification) throws UserException {
        char[] passwordArray;
        if (withVerification) {
            char[] passwordVerification;
            passwordArray = terminal.readSecret("Enter new password for the opensearch keystore (empty for no password): ", 128);
            if (!Arrays.equals(passwordArray, passwordVerification = terminal.readSecret("Enter same password again: ", 128))) {
                throw new UserException(65, "Passwords are not equal, exiting.");
            }
            Arrays.fill(passwordVerification, '\u0000');
        } else {
            passwordArray = terminal.readSecret("Enter password for the opensearch keystore : ");
        }
        return new SecureString(passwordArray);
    }

    protected static void decryptKeyStore(KeyStoreWrapper keyStore, Terminal terminal) throws UserException, GeneralSecurityException, IOException {
        try (SecureString keystorePassword = keyStore.hasPassword() ? KeyStoreAwareCommand.readPassword(terminal, false) : new SecureString(new char[0]);){
            keyStore.decrypt(keystorePassword.getChars());
        }
        catch (SecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }

    @Override
    protected abstract void execute(Terminal var1, OptionSet var2, Environment var3) throws Exception;
}

