/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.bootstrap;

import java.io.IOError;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.common.SuppressForbidden;

class OpenSearchUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = LogManager.getLogger(OpenSearchUncaughtExceptionHandler.class);

    OpenSearchUncaughtExceptionHandler() {
    }

    @Override
    public void uncaughtException(Thread thread, Throwable t) {
        if (OpenSearchUncaughtExceptionHandler.isFatalUncaught(t)) {
            try {
                this.onFatalUncaught(thread.getName(), t);
            }
            finally {
                if (t instanceof InternalError) {
                    this.halt(128);
                } else if (t instanceof OutOfMemoryError) {
                    this.halt(127);
                } else if (t instanceof StackOverflowError) {
                    this.halt(126);
                } else if (t instanceof UnknownError) {
                    this.halt(125);
                } else if (t instanceof IOError) {
                    this.halt(124);
                } else {
                    this.halt(1);
                }
            }
        } else {
            this.onNonFatalUncaught(thread.getName(), t);
        }
    }

    static boolean isFatalUncaught(Throwable e) {
        return e instanceof Error;
    }

    void onFatalUncaught(String threadName, Throwable t) {
        String message = "fatal error in thread [" + threadName + "], exiting";
        logger.error(message, t);
        Terminal.DEFAULT.errorPrintln(message);
        t.printStackTrace(Terminal.DEFAULT.getErrorWriter());
        Terminal.DEFAULT.flush();
    }

    void onNonFatalUncaught(String threadName, Throwable t) {
        String message = "uncaught exception in thread [" + threadName + "]";
        logger.error(message, t);
        Terminal.DEFAULT.errorPrintln(message);
        t.printStackTrace(Terminal.DEFAULT.getErrorWriter());
        Terminal.DEFAULT.flush();
    }

    void halt(int status) {
        AccessController.doPrivileged(new PrivilegedHaltAction(status));
    }

    static class PrivilegedHaltAction
    implements PrivilegedAction<Void> {
        private final int status;

        private PrivilegedHaltAction(int status) {
            this.status = status;
        }

        @Override
        @SuppressForbidden(reason="halt")
        public Void run() {
            Runtime.getRuntime().halt(this.status);
            return null;
        }
    }
}

