/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.bootstrap;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.common.SuppressForbidden;

public class JdkJarHellCheck {
    private Set<String> detected = new HashSet<String>();

    private void scanForJDKJarHell(final Path root) throws IOException {
        final ClassLoader ext = ClassLoader.getSystemClassLoader().getParent();
        assert (ext != null);
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String entry = root.relativize(file).toString().replace('\\', '/');
                if (entry.endsWith(".class") && !entry.endsWith("module-info.class") && ext.getResource(entry) != null) {
                    JdkJarHellCheck.this.detected.add(entry.replace("/", ".").replace(".class", ""));
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Set<String> getDetected() {
        return Collections.unmodifiableSet(this.detected);
    }

    @SuppressForbidden(reason="command line tool")
    public static void main(String[] argv) throws IOException {
        JdkJarHellCheck checker = new JdkJarHellCheck();
        for (String location : argv) {
            Path path = Paths.get(location, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalArgumentException("Path does not exist: " + path);
            }
            checker.scanForJDKJarHell(path);
        }
        if (checker.getDetected().isEmpty()) {
            System.exit(0);
        } else {
            checker.getDetected().forEach(System.out::println);
            System.exit(1);
        }
    }
}

