/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.single.shard;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;

public abstract class SingleShardRequest<Request extends SingleShardRequest<Request>>
extends ActionRequest
implements IndicesRequest {
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    @Nullable
    protected String index;
    ShardId internalShardId;

    public SingleShardRequest() {
    }

    public SingleShardRequest(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.internalShardId = new ShardId(in);
        }
        this.index = in.readOptionalString();
    }

    protected SingleShardRequest(String index) {
        this.index = index;
    }

    protected ActionRequestValidationException validateNonNullIndex() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return INDICES_OPTIONS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.internalShardId);
        out.writeOptionalString(this.index);
    }
}

