/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseContext;

public interface SearchRequestOperationsListener {
    public void onPhaseStart(SearchPhaseContext var1);

    public void onPhaseEnd(SearchPhaseContext var1);

    public void onPhaseFailure(SearchPhaseContext var1);

    public static final class CompositeListener
    implements SearchRequestOperationsListener {
        private final List<SearchRequestOperationsListener> listeners;
        private final Logger logger;

        public CompositeListener(List<SearchRequestOperationsListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        public void onPhaseStart(SearchPhaseContext context) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseStart(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseStart listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onPhaseEnd(SearchPhaseContext context) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseEnd(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseEnd listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onPhaseFailure(SearchPhaseContext context) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseFailure(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseFailure listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }
    }
}

