/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchContextId;

public final class SearchContextIdForNode
implements Writeable {
    private final String node;
    private final ShardSearchContextId searchContextId;
    private final String clusterAlias;

    public SearchContextIdForNode(@Nullable String clusterAlias, String node, ShardSearchContextId searchContextId) {
        this.node = node;
        this.clusterAlias = clusterAlias;
        this.searchContextId = searchContextId;
    }

    SearchContextIdForNode(StreamInput in) throws IOException {
        this.node = in.readString();
        this.clusterAlias = in.readOptionalString();
        this.searchContextId = new ShardSearchContextId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.node);
        out.writeOptionalString(this.clusterAlias);
        this.searchContextId.writeTo(out);
    }

    public String getNode() {
        return this.node;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ShardSearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    public String toString() {
        return "SearchContextIdForNode{node='" + this.node + "', seachContextId=" + this.searchContextId + ", clusterAlias='" + this.clusterAlias + "'}";
    }
}

