/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class DeletePitRequest
extends ActionRequest
implements ToXContentObject {
    private final List<String> pitIds = new ArrayList<String>();

    public DeletePitRequest(StreamInput in) throws IOException {
        super(in);
        this.pitIds.addAll(Arrays.asList(in.readStringArray()));
    }

    public DeletePitRequest(String ... pitIds) {
        this.pitIds.addAll(Arrays.asList(pitIds));
    }

    public DeletePitRequest(List<String> pitIds) {
        this.pitIds.addAll(pitIds);
    }

    public void clearAndSetPitIds(List<String> pitIds) {
        this.pitIds.clear();
        this.pitIds.addAll(pitIds);
    }

    public DeletePitRequest() {
    }

    public List<String> getPitIds() {
        return this.pitIds;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.pitIds == null || this.pitIds.isEmpty()) {
            validationException = ValidateActions.addValidationError("no pit ids specified", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.pitIds == null) {
            out.writeVInt(0);
        } else {
            out.writeStringArray(this.pitIds.toArray(new String[this.pitIds.size()]));
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("pit_id");
        for (String pitId : this.pitIds) {
            builder.value(pitId);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        this.pitIds.clear();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("pit_id".equals(currentFieldName)) {
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException("pit_id array element should only contain pit_id");
                        }
                        this.pitIds.add(parser.text());
                    }
                    continue;
                }
                if (!token.isValue()) {
                    throw new IllegalArgumentException("pit_id element should only contain pit_id");
                }
                this.pitIds.add(parser.text());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + token + "] ");
        }
    }
}

