/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.resync;

import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.action.resync.ResyncReplicationRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.resync.ResyncReplicationResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationOperation;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.ReplicationResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.TransportReplicationAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.replication.TransportWriteAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.action.shard.ShardStateAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexingPressureService;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Engine;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.PrimaryReplicaSyncer;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.SystemIndices;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportResyncReplicationAction
extends TransportWriteAction<ResyncReplicationRequest, ResyncReplicationRequest, ResyncReplicationResponse>
implements PrimaryReplicaSyncer.SyncAction {
    private static String ACTION_NAME = "internal:index/seq_no/resync";
    private static final Function<IndexShard, String> EXECUTOR_NAME_FUNCTION = shard -> {
        if (shard.indexSettings().getIndexMetadata().isSystem()) {
            return "system_write";
        }
        return "write";
    };

    @Inject
    public TransportResyncReplicationAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexingPressureService indexingPressureService, SystemIndices systemIndices) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, ResyncReplicationRequest::new, ResyncReplicationRequest::new, EXECUTOR_NAME_FUNCTION, true, indexingPressureService, systemIndices);
    }

    @Override
    protected void doExecute(Task parentTask, ResyncReplicationRequest request, ActionListener<ResyncReplicationResponse> listener) {
        assert (false) : "use TransportResyncReplicationAction#sync";
    }

    @Override
    protected ResyncReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ResyncReplicationResponse(in);
    }

    @Override
    protected ReplicationOperation.Replicas newReplicasProxy() {
        return new ResyncActionReplicasProxy();
    }

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return null;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected void dispatchedShardOperationOnPrimary(ResyncReplicationRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>> listener) {
        ActionListener.completeWith(listener, () -> new TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse>(TransportResyncReplicationAction.performOnPrimary(request), new ResyncReplicationResponse(), null, null, primary, this.logger));
    }

    @Override
    protected long primaryOperationSize(ResyncReplicationRequest request) {
        return Stream.of(request.getOperations()).mapToLong(Translog.Operation::estimateSize).sum();
    }

    public static ResyncReplicationRequest performOnPrimary(ResyncReplicationRequest request) {
        return request;
    }

    @Override
    protected void dispatchedShardOperationOnReplica(ResyncReplicationRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            Translog.Location location = TransportResyncReplicationAction.performOnReplica(request, replica);
            return new TransportWriteAction.WriteReplicaResult<ResyncReplicationRequest>(request, location, null, replica, this.logger);
        });
    }

    @Override
    protected long replicaOperationSize(ResyncReplicationRequest request) {
        return Stream.of(request.getOperations()).mapToLong(Translog.Operation::estimateSize).sum();
    }

    public static Translog.Location performOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        replica.updateMaxUnsafeAutoIdTimestamp(request.getMaxSeenAutoIdTimestampOnPrimary());
        for (Translog.Operation operation : request.getOperations()) {
            Engine.Result operationResult = replica.applyTranslogOperation(operation, Engine.Operation.Origin.REPLICA);
            if (operationResult.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + operationResult.getRequiredMappingUpdate());
            }
            location = TransportResyncReplicationAction.syncOperationResultOrThrow(operationResult, location);
        }
        if (request.getTrimAboveSeqNo() != -2L) {
            replica.trimOperationOfPreviousPrimaryTerms(request.getTrimAboveSeqNo());
        }
        return location;
    }

    @Override
    public void sync(ResyncReplicationRequest request, Task parentTask, String primaryAllocationId, long primaryTerm, final ActionListener<ResyncReplicationResponse> listener) {
        this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<ResyncReplicationRequest>(request, primaryAllocationId, primaryTerm), parentTask, this.transportOptions, new TransportResponseHandler<ResyncReplicationResponse>(){

            @Override
            public ResyncReplicationResponse read(StreamInput in) throws IOException {
                return TransportResyncReplicationAction.this.newResponseInstance(in);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public void handleResponse(ResyncReplicationResponse response) {
                ReplicationResponse.ShardInfo.Failure[] failures = response.getShardInfo().getFailures();
                for (int i = 0; i < failures.length; ++i) {
                    ReplicationResponse.ShardInfo.Failure f = failures[i];
                    TransportResyncReplicationAction.this.logger.info((Message)new ParameterizedMessage("{} primary-replica resync to replica on node [{}] failed", (Object)f.fullShardId(), (Object)f.nodeId()), f.getCause());
                }
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                listener.onFailure(exp);
            }
        });
    }

    class ResyncActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        ResyncActionReplicasProxy() {
            super(TransportResyncReplicationAction.this);
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            TransportResyncReplicationAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, false, message, exception, listener);
        }
    }
}

