/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.main;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.Build;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class MainResponse
extends ActionResponse
implements ToXContentObject {
    private String nodeName;
    private Version version;
    private ClusterName clusterName;
    private String clusterUuid;
    private Build build;
    private String versionNumber;
    public static final String TAGLINE = "The OpenSearch Project: https://opensearch.org/";
    private static final ObjectParser<MainResponse, Void> PARSER = new ObjectParser(MainResponse.class.getName(), true, MainResponse::new);

    MainResponse() {
    }

    MainResponse(StreamInput in) throws IOException {
        super(in);
        this.nodeName = in.readString();
        this.version = in.readVersion();
        this.clusterName = new ClusterName(in);
        this.clusterUuid = in.readString();
        this.build = in.readBuild();
        if (in.getVersion().before(LegacyESVersion.V_7_0_0)) {
            in.readBoolean();
        }
        this.versionNumber = this.build.getQualifiedVersion();
    }

    public MainResponse(String nodeName, Version version, ClusterName clusterName, String clusterUuid, Build build) {
        this.nodeName = nodeName;
        this.version = version;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
        this.versionNumber = build.getQualifiedVersion();
    }

    public MainResponse(String nodeName, Version version, ClusterName clusterName, String clusterUuid, Build build, String versionNumber) {
        this.nodeName = nodeName;
        this.version = version;
        this.clusterName = clusterName;
        this.clusterUuid = clusterUuid;
        this.build = build;
        this.versionNumber = versionNumber;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Version getVersion() {
        return this.version;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public String getClusterUuid() {
        return this.clusterUuid;
    }

    public Build getBuild() {
        return this.build;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        if (out.getVersion().before(Version.V_1_0_0)) {
            out.writeVersion(LegacyESVersion.V_7_10_2);
        } else {
            out.writeVersion(this.version);
        }
        this.clusterName.writeTo(out);
        out.writeString(this.clusterUuid);
        out.writeBuild(this.build);
        if (out.getVersion().before(LegacyESVersion.V_7_0_0)) {
            out.writeBoolean(true);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.nodeName);
        builder.field("cluster_name", this.clusterName.value());
        builder.field("cluster_uuid", this.clusterUuid);
        builder.startObject("version");
        if (this.isCompatibilityModeDisabled()) {
            builder.field("distribution", this.build.getDistribution());
        }
        builder.field("number", this.versionNumber).field("build_type", this.build.type().displayName()).field("build_hash", this.build.hash()).field("build_date", this.build.date()).field("build_snapshot", this.build.isSnapshot()).field("lucene_version", this.version.luceneVersion.toString()).field("minimum_wire_compatibility_version", this.version.minimumCompatibilityVersion().toString()).field("minimum_index_compatibility_version", this.version.minimumIndexCompatibilityVersion().toString()).endObject();
        builder.field("tagline", TAGLINE);
        builder.endObject();
        return builder;
    }

    private boolean isCompatibilityModeDisabled() {
        return this.build.getQualifiedVersion().equals(this.versionNumber);
    }

    public static MainResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MainResponse other = (MainResponse)o;
        return Objects.equals(this.nodeName, other.nodeName) && Objects.equals(this.version, other.version) && Objects.equals(this.clusterUuid, other.clusterUuid) && Objects.equals(this.build, other.build) && Objects.equals(this.clusterName, other.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.nodeName, this.version, this.clusterUuid, this.build, this.clusterName);
    }

    public String toString() {
        return "MainResponse{nodeName='" + this.nodeName + "', version=" + this.version + ", clusterName=" + this.clusterName + ", clusterUuid='" + this.clusterUuid + "', build=" + this.build + "}";
    }

    static {
        PARSER.declareString((response, value) -> {
            response.nodeName = value;
        }, new ParseField("name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterName = new ClusterName((String)value);
        }, new ParseField("cluster_name", new String[0]));
        PARSER.declareString((response, value) -> {
            response.clusterUuid = value;
        }, new ParseField("cluster_uuid", new String[0]));
        PARSER.declareString((response, value) -> {}, new ParseField("tagline", new String[0]));
        PARSER.declareObject((response, value) -> {
            String buildType = (String)value.get("build_type");
            response.build = new Build(buildType == null ? Build.Type.UNKNOWN : Build.Type.fromDisplayName(buildType, false), (String)value.get("build_hash"), (String)value.get("build_date"), (Boolean)value.get("build_snapshot"), (String)value.get("number"), (String)value.get("distribution"));
            response.version = Version.fromString(((String)value.get("number")).replace("-SNAPSHOT", "").replaceFirst("-(alpha\\d+|beta\\d+|rc\\d+)", ""));
            response.versionNumber = response.version.toString();
        }, (parser, context) -> parser.map(), new ParseField("version", new String[0]));
    }
}

