/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulateDocumentBaseResult;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulateDocumentResult;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulateDocumentVerboseResult;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulateProcessorResult;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.WriteableIngestDocument;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParserUtils;

public class SimulatePipelineResponse
extends ActionResponse
implements ToXContentObject {
    private String pipelineId;
    private boolean verbose;
    private List<SimulateDocumentResult> results;
    public static final ConstructingObjectParser<SimulatePipelineResponse, Void> PARSER = new ConstructingObjectParser("simulate_pipeline_response", true, a -> {
        List results = (List)a[0];
        boolean verbose = false;
        if (results.size() > 0 && results.get(0) instanceof SimulateDocumentVerboseResult) {
            verbose = true;
        }
        return new SimulatePipelineResponse(null, verbose, results);
    });

    public SimulatePipelineResponse(StreamInput in) throws IOException {
        super(in);
        this.pipelineId = in.readOptionalString();
        boolean verbose = in.readBoolean();
        int responsesLength = in.readVInt();
        this.results = new ArrayList<SimulateDocumentResult>();
        for (int i = 0; i < responsesLength; ++i) {
            SimulateDocumentResult simulateDocumentResult = verbose ? new SimulateDocumentVerboseResult(in) : new SimulateDocumentBaseResult(in);
            this.results.add(simulateDocumentResult);
        }
    }

    public SimulatePipelineResponse(String pipelineId, boolean verbose, List<SimulateDocumentResult> responses) {
        this.pipelineId = pipelineId;
        this.verbose = verbose;
        this.results = Collections.unmodifiableList(responses);
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public List<SimulateDocumentResult> getResults() {
        return this.results;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.pipelineId);
        out.writeBoolean(this.verbose);
        out.writeVInt(this.results.size());
        for (SimulateDocumentResult response : this.results) {
            response.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("docs");
        for (SimulateDocumentResult response : this.results) {
            response.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SimulatePipelineResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, context) -> {
            XContentParser.Token token = parser.currentToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            SimulateDocumentResult result = null;
            block8: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                String fieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    if (fieldName.equals("processor_results")) {
                        ArrayList<SimulateProcessorResult> results = new ArrayList<SimulateProcessorResult>();
                        while ((token = parser.nextToken()) == XContentParser.Token.START_OBJECT) {
                            results.add(SimulateProcessorResult.fromXContent(parser));
                        }
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_ARRAY, token, parser);
                        result = new SimulateDocumentVerboseResult(results);
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (!token.equals((Object)XContentParser.Token.START_OBJECT)) continue;
                switch (fieldName) {
                    case "doc": {
                        result = new SimulateDocumentBaseResult(WriteableIngestDocument.INGEST_DOC_PARSER.apply(parser, null).getIngestDocument());
                        continue block8;
                    }
                    case "error": {
                        result = new SimulateDocumentBaseResult(OpenSearchException.fromXContent(parser));
                        continue block8;
                    }
                }
                parser.skipChildren();
            }
            assert (result != null);
            return result;
        }, new ParseField("docs", new String[0]));
    }

    static final class Fields {
        static final String DOCUMENTS = "docs";

        Fields() {
        }
    }
}

