/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.ingest;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.SimulateDocumentResult;
import org.graylog.shaded.opensearch2.org.opensearch.action.ingest.WriteableIngestDocument;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestDocument;

public final class SimulateDocumentBaseResult
implements SimulateDocumentResult {
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;
    public static final ConstructingObjectParser<SimulateDocumentBaseResult, Void> PARSER = new ConstructingObjectParser("simulate_document_base_result", true, a -> {
        if (a[1] == null) {
            assert (a[0] != null);
            return new SimulateDocumentBaseResult(((WriteableIngestDocument)a[0]).getIngestDocument());
        }
        assert (a[0] == null);
        return new SimulateDocumentBaseResult((OpenSearchException)a[1]);
    });

    public SimulateDocumentBaseResult(IngestDocument ingestDocument) {
        this.ingestDocument = ingestDocument != null ? new WriteableIngestDocument(ingestDocument) : null;
        this.failure = null;
    }

    public SimulateDocumentBaseResult(Exception failure) {
        this.ingestDocument = null;
        this.failure = failure;
    }

    public SimulateDocumentBaseResult(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
            this.failure = in.readException();
            this.ingestDocument = in.readOptionalWriteable(WriteableIngestDocument::new);
        } else if (in.readBoolean()) {
            this.ingestDocument = null;
            this.failure = in.readException();
        } else {
            this.ingestDocument = new WriteableIngestDocument(in);
            this.failure = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
            out.writeException(this.failure);
            out.writeOptionalWriteable(this.ingestDocument);
        } else if (this.failure == null) {
            out.writeBoolean(false);
            this.ingestDocument.writeTo(out);
        } else {
            out.writeBoolean(true);
            out.writeException(this.failure);
        }
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public Exception getFailure() {
        return this.failure;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.failure == null && this.ingestDocument == null) {
            builder.nullValue();
            return builder;
        }
        builder.startObject();
        if (this.failure == null) {
            this.ingestDocument.toXContent(builder, params);
        } else {
            OpenSearchException.generateFailureXContent(builder, params, this.failure, true);
        }
        builder.endObject();
        return builder;
    }

    public static SimulateDocumentBaseResult fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), WriteableIngestDocument.INGEST_DOC_PARSER, new ParseField("doc", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> OpenSearchException.fromXContent(p), new ParseField("error", new String[0]));
    }
}

