/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.cache.query.QueryCacheStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.cache.request.RequestCacheStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.SegmentsStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.FieldDataStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.flush.FlushStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.get.GetStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.merge.MergeStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.recovery.RecoveryStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.refresh.RefreshStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.search.stats.SearchStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.DocsStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexingStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.warmer.WarmerStats;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesQueryCache;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.completion.CompletionStats;

public class CommonStats
implements Writeable,
ToXContentFragment {
    @Nullable
    public DocsStats docs;
    @Nullable
    public StoreStats store;
    @Nullable
    public IndexingStats indexing;
    @Nullable
    public GetStats get;
    @Nullable
    public SearchStats search;
    @Nullable
    public MergeStats merge;
    @Nullable
    public RefreshStats refresh;
    @Nullable
    public FlushStats flush;
    @Nullable
    public WarmerStats warmer;
    @Nullable
    public QueryCacheStats queryCache;
    @Nullable
    public FieldDataStats fieldData;
    @Nullable
    public CompletionStats completion;
    @Nullable
    public SegmentsStats segments;
    @Nullable
    public TranslogStats translog;
    @Nullable
    public RequestCacheStats requestCache;
    @Nullable
    public RecoveryStats recoveryStats;

    public CommonStats() {
        this(CommonStatsFlags.NONE);
    }

    public CommonStats(CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        block18: for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            switch (flag) {
                case Docs: {
                    this.docs = new DocsStats();
                    continue block18;
                }
                case Store: {
                    this.store = new StoreStats();
                    continue block18;
                }
                case Indexing: {
                    this.indexing = new IndexingStats();
                    continue block18;
                }
                case Get: {
                    this.get = new GetStats();
                    continue block18;
                }
                case Search: {
                    this.search = new SearchStats();
                    continue block18;
                }
                case Merge: {
                    this.merge = new MergeStats();
                    continue block18;
                }
                case Refresh: {
                    this.refresh = new RefreshStats();
                    continue block18;
                }
                case Flush: {
                    this.flush = new FlushStats();
                    continue block18;
                }
                case Warmer: {
                    this.warmer = new WarmerStats();
                    continue block18;
                }
                case QueryCache: {
                    this.queryCache = new QueryCacheStats();
                    continue block18;
                }
                case FieldData: {
                    this.fieldData = new FieldDataStats();
                    continue block18;
                }
                case Completion: {
                    this.completion = new CompletionStats();
                    continue block18;
                }
                case Segments: {
                    this.segments = new SegmentsStats();
                    continue block18;
                }
                case Translog: {
                    this.translog = new TranslogStats();
                    continue block18;
                }
                case RequestCache: {
                    this.requestCache = new RequestCacheStats();
                    continue block18;
                }
                case Recovery: {
                    this.recoveryStats = new RecoveryStats();
                    continue block18;
                }
                default: {
                    throw new IllegalStateException("Unknown Flag: " + flag);
                }
            }
        }
    }

    public CommonStats(IndicesQueryCache indicesQueryCache, IndexShard indexShard, CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            try {
                switch (flag) {
                    case Docs: {
                        this.docs = indexShard.docStats();
                        break;
                    }
                    case Store: {
                        this.store = indexShard.storeStats();
                        break;
                    }
                    case Indexing: {
                        this.indexing = indexShard.indexingStats();
                        break;
                    }
                    case Get: {
                        this.get = indexShard.getStats();
                        break;
                    }
                    case Search: {
                        this.search = indexShard.searchStats(flags.groups());
                        break;
                    }
                    case Merge: {
                        this.merge = indexShard.mergeStats();
                        break;
                    }
                    case Refresh: {
                        this.refresh = indexShard.refreshStats();
                        break;
                    }
                    case Flush: {
                        this.flush = indexShard.flushStats();
                        break;
                    }
                    case Warmer: {
                        this.warmer = indexShard.warmerStats();
                        break;
                    }
                    case QueryCache: {
                        this.queryCache = indicesQueryCache.getStats(indexShard.shardId());
                        break;
                    }
                    case FieldData: {
                        this.fieldData = indexShard.fieldDataStats(flags.fieldDataFields());
                        break;
                    }
                    case Completion: {
                        this.completion = indexShard.completionStats(flags.completionDataFields());
                        break;
                    }
                    case Segments: {
                        this.segments = indexShard.segmentStats(flags.includeSegmentFileSizes(), flags.includeUnloadedSegments());
                        break;
                    }
                    case Translog: {
                        this.translog = indexShard.translogStats();
                        break;
                    }
                    case RequestCache: {
                        this.requestCache = indexShard.requestCache().stats();
                        break;
                    }
                    case Recovery: {
                        this.recoveryStats = indexShard.recoveryStats();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown Flag: " + flag);
                    }
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    public CommonStats(StreamInput in) throws IOException {
        this.docs = in.readOptionalWriteable(DocsStats::new);
        this.store = in.readOptionalWriteable(StoreStats::new);
        this.indexing = in.readOptionalWriteable(IndexingStats::new);
        this.get = in.readOptionalWriteable(GetStats::new);
        this.search = in.readOptionalWriteable(SearchStats::new);
        this.merge = in.readOptionalWriteable(MergeStats::new);
        this.refresh = in.readOptionalWriteable(RefreshStats::new);
        this.flush = in.readOptionalWriteable(FlushStats::new);
        this.warmer = in.readOptionalWriteable(WarmerStats::new);
        this.queryCache = in.readOptionalWriteable(QueryCacheStats::new);
        this.fieldData = in.readOptionalWriteable(FieldDataStats::new);
        this.completion = in.readOptionalWriteable(CompletionStats::new);
        this.segments = in.readOptionalWriteable(SegmentsStats::new);
        this.translog = in.readOptionalWriteable(TranslogStats::new);
        this.requestCache = in.readOptionalWriteable(RequestCacheStats::new);
        this.recoveryStats = in.readOptionalWriteable(RecoveryStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.docs);
        out.writeOptionalWriteable(this.store);
        out.writeOptionalWriteable(this.indexing);
        out.writeOptionalWriteable(this.get);
        out.writeOptionalWriteable(this.search);
        out.writeOptionalWriteable(this.merge);
        out.writeOptionalWriteable(this.refresh);
        out.writeOptionalWriteable(this.flush);
        out.writeOptionalWriteable(this.warmer);
        out.writeOptionalWriteable(this.queryCache);
        out.writeOptionalWriteable(this.fieldData);
        out.writeOptionalWriteable(this.completion);
        out.writeOptionalWriteable(this.segments);
        out.writeOptionalWriteable(this.translog);
        out.writeOptionalWriteable(this.requestCache);
        out.writeOptionalWriteable(this.recoveryStats);
    }

    public void add(CommonStats stats) {
        if (this.docs == null) {
            if (stats.getDocs() != null) {
                this.docs = new DocsStats();
                this.docs.add(stats.getDocs());
            }
        } else {
            this.docs.add(stats.getDocs());
        }
        if (this.store == null) {
            if (stats.getStore() != null) {
                this.store = new StoreStats();
                this.store.add(stats.getStore());
            }
        } else {
            this.store.add(stats.getStore());
        }
        if (this.indexing == null) {
            if (stats.getIndexing() != null) {
                this.indexing = new IndexingStats();
                this.indexing.add(stats.getIndexing());
            }
        } else {
            this.indexing.add(stats.getIndexing());
        }
        if (this.get == null) {
            if (stats.getGet() != null) {
                this.get = new GetStats();
                this.get.add(stats.getGet());
            }
        } else {
            this.get.add(stats.getGet());
        }
        if (this.search == null) {
            if (stats.getSearch() != null) {
                this.search = new SearchStats();
                this.search.add(stats.getSearch());
            }
        } else {
            this.search.add(stats.getSearch());
        }
        if (this.merge == null) {
            if (stats.getMerge() != null) {
                this.merge = new MergeStats();
                this.merge.add(stats.getMerge());
            }
        } else {
            this.merge.add(stats.getMerge());
        }
        if (this.refresh == null) {
            if (stats.getRefresh() != null) {
                this.refresh = new RefreshStats();
                this.refresh.add(stats.getRefresh());
            }
        } else {
            this.refresh.add(stats.getRefresh());
        }
        if (this.flush == null) {
            if (stats.getFlush() != null) {
                this.flush = new FlushStats();
                this.flush.add(stats.getFlush());
            }
        } else {
            this.flush.add(stats.getFlush());
        }
        if (this.warmer == null) {
            if (stats.getWarmer() != null) {
                this.warmer = new WarmerStats();
                this.warmer.add(stats.getWarmer());
            }
        } else {
            this.warmer.add(stats.getWarmer());
        }
        if (this.queryCache == null) {
            if (stats.getQueryCache() != null) {
                this.queryCache = new QueryCacheStats();
                this.queryCache.add(stats.getQueryCache());
            }
        } else {
            this.queryCache.add(stats.getQueryCache());
        }
        if (this.fieldData == null) {
            if (stats.getFieldData() != null) {
                this.fieldData = new FieldDataStats();
                this.fieldData.add(stats.getFieldData());
            }
        } else {
            this.fieldData.add(stats.getFieldData());
        }
        if (this.completion == null) {
            if (stats.getCompletion() != null) {
                this.completion = new CompletionStats();
                this.completion.add(stats.getCompletion());
            }
        } else {
            this.completion.add(stats.getCompletion());
        }
        if (this.segments == null) {
            if (stats.getSegments() != null) {
                this.segments = new SegmentsStats();
                this.segments.add(stats.getSegments());
            }
        } else {
            this.segments.add(stats.getSegments());
        }
        if (this.translog == null) {
            if (stats.getTranslog() != null) {
                this.translog = new TranslogStats();
                this.translog.add(stats.getTranslog());
            }
        } else {
            this.translog.add(stats.getTranslog());
        }
        if (this.requestCache == null) {
            if (stats.getRequestCache() != null) {
                this.requestCache = new RequestCacheStats();
                this.requestCache.add(stats.getRequestCache());
            }
        } else {
            this.requestCache.add(stats.getRequestCache());
        }
        if (this.recoveryStats == null) {
            if (stats.getRecoveryStats() != null) {
                this.recoveryStats = new RecoveryStats();
                this.recoveryStats.add(stats.getRecoveryStats());
            }
        } else {
            this.recoveryStats.add(stats.getRecoveryStats());
        }
    }

    @Nullable
    public DocsStats getDocs() {
        return this.docs;
    }

    @Nullable
    public StoreStats getStore() {
        return this.store;
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.indexing;
    }

    @Nullable
    public GetStats getGet() {
        return this.get;
    }

    @Nullable
    public SearchStats getSearch() {
        return this.search;
    }

    @Nullable
    public MergeStats getMerge() {
        return this.merge;
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.refresh;
    }

    @Nullable
    public FlushStats getFlush() {
        return this.flush;
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.warmer;
    }

    @Nullable
    public QueryCacheStats getQueryCache() {
        return this.queryCache;
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.fieldData;
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.completion;
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.segments;
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.translog;
    }

    @Nullable
    public RequestCacheStats getRequestCache() {
        return this.requestCache;
    }

    @Nullable
    public RecoveryStats getRecoveryStats() {
        return this.recoveryStats;
    }

    public ByteSizeValue getTotalMemory() {
        long size = 0L;
        if (this.getFieldData() != null) {
            size += this.getFieldData().getMemorySizeInBytes();
        }
        if (this.getQueryCache() != null) {
            size += this.getQueryCache().getMemorySizeInBytes();
        }
        if (this.getSegments() != null) {
            size += this.getSegments().getIndexWriterMemoryInBytes() + this.getSegments().getVersionMapMemoryInBytes();
        }
        return new ByteSizeValue(size);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Stream<ToXContent> stream = Arrays.stream(new ToXContent[]{this.docs, this.store, this.indexing, this.get, this.search, this.merge, this.refresh, this.flush, this.warmer, this.queryCache, this.fieldData, this.completion, this.segments, this.translog, this.requestCache, this.recoveryStats}).filter(Objects::nonNull);
        for (ToXContent toXContent : stream::iterator) {
            toXContent.toXContent(builder, params);
        }
        return builder;
    }
}

