/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.resolve;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.StreamSupport;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionType;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.OriginalIndices;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.HandledTransportAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.Client;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexAbstraction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexAbstractionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.CountDown;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteClusterAware;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class ResolveIndexAction
extends ActionType<Response> {
    public static final ResolveIndexAction INSTANCE = new ResolveIndexAction();
    public static final String NAME = "indices:admin/resolve/index";

    private ResolveIndexAction() {
        super(NAME, Response::new);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final ThreadPool threadPool;
        private final ClusterService clusterService;
        private final RemoteClusterService remoteClusterService;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final IndexAbstractionResolver indexAbstractionResolver;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(ResolveIndexAction.NAME, transportService, actionFilters, Request::new);
            this.threadPool = threadPool;
            this.clusterService = clusterService;
            this.remoteClusterService = transportService.getRemoteClusterService();
            this.indexNameExpressionResolver = indexNameExpressionResolver;
            this.indexAbstractionResolver = new IndexAbstractionResolver(indexNameExpressionResolver);
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            ClusterState clusterState = this.clusterService.state();
            Map<String, OriginalIndices> remoteClusterIndices = this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices(), idx -> this.indexNameExpressionResolver.hasIndexAbstraction((String)idx, clusterState));
            OriginalIndices localIndices = remoteClusterIndices.remove("");
            Metadata metadata = clusterState.metadata();
            ArrayList<ResolvedIndex> indices = new ArrayList<ResolvedIndex>();
            ArrayList<ResolvedAlias> aliases = new ArrayList<ResolvedAlias>();
            ArrayList<ResolvedDataStream> dataStreams = new ArrayList<ResolvedDataStream>();
            if (localIndices != null) {
                TransportAction.resolveIndices(localIndices.indices(), request.indicesOptions, metadata, this.indexAbstractionResolver, indices, aliases, dataStreams, request.includeDataStreams());
            }
            if (remoteClusterIndices.size() > 0) {
                int remoteRequests = remoteClusterIndices.size();
                CountDown completionCounter = new CountDown(remoteRequests);
                SortedMap remoteResponses = Collections.synchronizedSortedMap(new TreeMap());
                Runnable terminalHandler = () -> {
                    if (completionCounter.countDown()) {
                        TransportAction.mergeResults(remoteResponses, indices, aliases, dataStreams);
                        listener.onResponse(new Response(indices, aliases, dataStreams));
                    }
                };
                for (Map.Entry<String, OriginalIndices> remoteIndices : remoteClusterIndices.entrySet()) {
                    String clusterAlias = remoteIndices.getKey();
                    OriginalIndices originalIndices = remoteIndices.getValue();
                    Client remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(this.threadPool, clusterAlias);
                    Request remoteRequest = new Request(originalIndices.indices(), originalIndices.indicesOptions());
                    remoteClusterClient.admin().indices().resolveIndex(remoteRequest, ActionListener.wrap(response -> {
                        remoteResponses.put(clusterAlias, response);
                        terminalHandler.run();
                    }, failure -> terminalHandler.run()));
                }
            } else {
                listener.onResponse(new Response(indices, aliases, dataStreams));
            }
        }

        static void resolveIndices(String[] names, IndicesOptions indicesOptions, Metadata metadata, IndexAbstractionResolver resolver, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams, boolean includeDataStreams) {
            List<String> resolvedIndexAbstractions = resolver.resolveIndexAbstractions(names, indicesOptions, metadata, includeDataStreams);
            SortedMap<String, IndexAbstraction> lookup = metadata.getIndicesLookup();
            for (String s : resolvedIndexAbstractions) {
                TransportAction.enrichIndexAbstraction(s, lookup, indices, aliases, dataStreams);
            }
            indices.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
            aliases.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
            dataStreams.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
        }

        private static void mergeResults(Map<String, Response> remoteResponses, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            for (Map.Entry<String, Response> responseEntry : remoteResponses.entrySet()) {
                String clusterAlias = responseEntry.getKey();
                Response response = responseEntry.getValue();
                for (ResolvedIndex index : response.indices) {
                    indices.add(index.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, index.getName())));
                }
                for (ResolvedAlias alias : response.aliases) {
                    aliases.add(alias.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, alias.getName())));
                }
                for (ResolvedDataStream dataStream : response.dataStreams) {
                    dataStreams.add(dataStream.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, dataStream.getName())));
                }
            }
        }

        private static void enrichIndexAbstraction(String indexAbstraction, SortedMap<String, IndexAbstraction> lookup, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            IndexAbstraction ia = (IndexAbstraction)lookup.get(indexAbstraction);
            if (ia != null) {
                switch (ia.getType()) {
                    case CONCRETE_INDEX: {
                        boolean isFrozen;
                        IndexAbstraction.Index index = (IndexAbstraction.Index)ia;
                        Object[] aliasNames = (String[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(index.getWriteIndex().getAliases().keySet().iterator(), 0), false).toArray(String[]::new);
                        Arrays.sort(aliasNames);
                        ArrayList<String> attributes = new ArrayList<String>();
                        attributes.add(index.getWriteIndex().getState() == IndexMetadata.State.OPEN ? "open" : "closed");
                        if (ia.isHidden()) {
                            attributes.add("hidden");
                        }
                        if (isFrozen = Boolean.parseBoolean(ia.getWriteIndex().getSettings().get("index.frozen"))) {
                            attributes.add("frozen");
                        }
                        attributes.sort(String::compareTo);
                        indices.add(new ResolvedIndex(index.getName(), (String[])aliasNames, attributes.toArray(Strings.EMPTY_ARRAY), index.getParentDataStream() == null ? null : index.getParentDataStream().getName()));
                        break;
                    }
                    case ALIAS: {
                        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)ia;
                        Object[] indexNames = (String[])alias.getIndices().stream().map(i -> i.getIndex().getName()).toArray(String[]::new);
                        Arrays.sort(indexNames);
                        aliases.add(new ResolvedAlias(alias.getName(), (String[])indexNames));
                        break;
                    }
                    case DATA_STREAM: {
                        IndexAbstraction.DataStream dataStream = (IndexAbstraction.DataStream)ia;
                        Object[] backingIndices = (String[])dataStream.getIndices().stream().map(i -> i.getIndex().getName()).toArray(String[]::new);
                        Arrays.sort(backingIndices);
                        dataStreams.add(new ResolvedDataStream(dataStream.getName(), (String[])backingIndices, dataStream.getDataStream().getTimeStampField().getName()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown index abstraction type: " + ia.getType());
                    }
                }
            }
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<ResolvedIndex> indices;
        private final List<ResolvedAlias> aliases;
        private final List<ResolvedDataStream> dataStreams;

        public Response(List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            this.indices = indices;
            this.aliases = aliases;
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this.indices = in.readList(ResolvedIndex::new);
            this.aliases = in.readList(ResolvedAlias::new);
            this.dataStreams = in.readList(ResolvedDataStream::new);
        }

        public List<ResolvedIndex> getIndices() {
            return this.indices;
        }

        public List<ResolvedAlias> getAliases() {
            return this.aliases;
        }

        public List<ResolvedDataStream> getDataStreams() {
            return this.dataStreams;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.indices);
            out.writeList(this.aliases);
            out.writeList(this.dataStreams);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDICES_FIELD.getPreferredName(), this.indices);
            builder.field(ALIASES_FIELD.getPreferredName(), this.aliases);
            builder.field(DATA_STREAMS_FIELD.getPreferredName(), this.dataStreams);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.indices.equals(response.indices) && this.aliases.equals(response.aliases) && this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.aliases, this.dataStreams);
        }
    }

    public static class ResolvedDataStream
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField BACKING_INDICES_FIELD = new ParseField("backing_indices", new String[0]);
        static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp_field", new String[0]);
        private final String[] backingIndices;
        private final String timestampField;

        ResolvedDataStream(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.backingIndices = in.readStringArray();
            this.timestampField = in.readString();
        }

        ResolvedDataStream(String name, String[] backingIndices, String timestampField) {
            super(name);
            this.backingIndices = backingIndices;
            this.timestampField = timestampField;
        }

        public ResolvedDataStream copy(String newName) {
            return new ResolvedDataStream(newName, this.backingIndices, this.timestampField);
        }

        public String[] getBackingIndices() {
            return this.backingIndices;
        }

        public String getTimestampField() {
            return this.timestampField;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.backingIndices);
            out.writeString(this.timestampField);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            builder.array(BACKING_INDICES_FIELD.getPreferredName(), this.backingIndices);
            builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestampField);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedDataStream dataStream = (ResolvedDataStream)o;
            return this.getName().equals(dataStream.getName()) && this.timestampField.equals(dataStream.timestampField) && Arrays.equals(this.backingIndices, dataStream.backingIndices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.timestampField);
            result = 31 * result + Arrays.hashCode(this.backingIndices);
            return result;
        }
    }

    public static class ResolvedAlias
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        private final String[] indices;

        ResolvedAlias(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.indices = in.readStringArray();
        }

        ResolvedAlias(String name, String[] indices) {
            super(name);
            this.indices = indices;
        }

        public ResolvedAlias copy(String newName) {
            return new ResolvedAlias(newName, this.indices);
        }

        public String[] getIndices() {
            return this.indices;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.indices);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.indices.length > 0) {
                builder.array(INDICES_FIELD.getPreferredName(), this.indices);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedAlias alias = (ResolvedAlias)o;
            return this.getName().equals(alias.getName()) && Arrays.equals(this.indices, alias.indices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName());
            result = 31 * result + Arrays.hashCode(this.indices);
            return result;
        }
    }

    public static class ResolvedIndex
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField ATTRIBUTES_FIELD = new ParseField("attributes", new String[0]);
        static final ParseField DATA_STREAM_FIELD = new ParseField("data_stream", new String[0]);
        private final String[] aliases;
        private final String[] attributes;
        private final String dataStream;

        ResolvedIndex(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.aliases = in.readStringArray();
            this.attributes = in.readStringArray();
            this.dataStream = in.readOptionalString();
        }

        ResolvedIndex(String name, String[] aliases, String[] attributes, @Nullable String dataStream) {
            super(name);
            this.aliases = aliases;
            this.attributes = attributes;
            this.dataStream = dataStream;
        }

        public ResolvedIndex copy(String newName) {
            return new ResolvedIndex(newName, this.aliases, this.attributes, this.dataStream);
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public String[] getAttributes() {
            return this.attributes;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.aliases);
            out.writeStringArray(this.attributes);
            out.writeOptionalString(this.dataStream);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.aliases.length > 0) {
                builder.array(ALIASES_FIELD.getPreferredName(), this.aliases);
            }
            builder.array(ATTRIBUTES_FIELD.getPreferredName(), this.attributes);
            if (!Strings.isNullOrEmpty(this.dataStream)) {
                builder.field(DATA_STREAM_FIELD.getPreferredName(), this.dataStream);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedIndex index = (ResolvedIndex)o;
            return this.getName().equals(index.getName()) && Objects.equals(this.dataStream, index.dataStream) && Arrays.equals(this.aliases, index.aliases) && Arrays.equals(this.attributes, index.attributes);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.dataStream);
            result = 31 * result + Arrays.hashCode(this.aliases);
            result = 31 * result + Arrays.hashCode(this.attributes);
            return result;
        }
    }

    public static class ResolvedIndexAbstraction {
        static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private String name;

        ResolvedIndexAbstraction() {
        }

        ResolvedIndexAbstraction(String name) {
            this.name = name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Request
    extends ActionRequest
    implements IndicesRequest.Replaceable {
        public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpen();
        private String[] names;
        private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;

        public Request(String[] names) {
            this.names = names;
        }

        public Request(String[] names, IndicesOptions indicesOptions) {
            this.names = names;
            this.indicesOptions = indicesOptions;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }
    }
}

