/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;

public class GetFieldMappingsRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    protected boolean local = false;
    private String[] fields = Strings.EMPTY_ARRAY;
    private boolean includeDefaults = false;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public GetFieldMappingsRequest() {
    }

    public GetFieldMappingsRequest(StreamInput in) throws IOException {
        super(in);
        Object[] types;
        this.indices = in.readStringArray();
        if (in.getVersion().before(Version.V_2_0_0) && (types = in.readStringArray()) != Strings.EMPTY_ARRAY) {
            throw new IllegalArgumentException("Expected empty type array but received [" + Arrays.toString(types) + "]");
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.local = in.readBoolean();
        this.fields = in.readStringArray();
        this.includeDefaults = in.readBoolean();
    }

    public GetFieldMappingsRequest local(boolean local) {
        this.local = local;
        return this;
    }

    public boolean local() {
        return this.local;
    }

    @Override
    public GetFieldMappingsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public GetFieldMappingsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public GetFieldMappingsRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    public GetFieldMappingsRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBoolean(this.local);
        out.writeStringArray(this.fields);
        out.writeBoolean(this.includeDefaults);
    }
}

