/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.DanglingIndexInfo;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.list.NodeListDanglingIndicesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterName;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.StatusToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class ListDanglingIndicesResponse
extends BaseNodesResponse<NodeListDanglingIndicesResponse>
implements StatusToXContentObject {
    public ListDanglingIndicesResponse(StreamInput in) throws IOException {
        super(in);
    }

    public ListDanglingIndicesResponse(ClusterName clusterName, List<NodeListDanglingIndicesResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    public RestStatus status() {
        return this.hasFailures() ? RestStatus.INTERNAL_SERVER_ERROR : RestStatus.OK;
    }

    static Collection<AggregatedDanglingIndexInfo> resultsByIndexUUID(List<NodeListDanglingIndicesResponse> nodes) {
        HashMap<String, AggregatedDanglingIndexInfo> byIndexUUID = new HashMap<String, AggregatedDanglingIndexInfo>();
        for (NodeListDanglingIndicesResponse nodeResponse : nodes) {
            for (DanglingIndexInfo info : nodeResponse.getDanglingIndices()) {
                String indexUUID = info.getIndexUUID();
                AggregatedDanglingIndexInfo aggregatedInfo = byIndexUUID.computeIfAbsent(indexUUID, _uuid -> new AggregatedDanglingIndexInfo(indexUUID, info.getIndexName(), info.getCreationDateMillis()));
                aggregatedInfo.nodeIds.add(info.getNodeId());
            }
        }
        return byIndexUUID.values();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("dangling_indices");
        for (AggregatedDanglingIndexInfo info : ListDanglingIndicesResponse.resultsByIndexUUID(this.getNodes())) {
            builder.startObject();
            builder.field("index_name", info.indexName);
            builder.field("index_uuid", info.indexUUID);
            builder.timeField("creation_date_millis", "creation_date", info.creationDateMillis);
            builder.array("node_ids", info.nodeIds.toArray(new String[0]));
            builder.endObject();
        }
        return builder.endArray();
    }

    @Override
    protected List<NodeListDanglingIndicesResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(NodeListDanglingIndicesResponse::new);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeListDanglingIndicesResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    static class AggregatedDanglingIndexInfo {
        private final String indexUUID;
        private final String indexName;
        private final long creationDateMillis;
        private final List<String> nodeIds;

        AggregatedDanglingIndexInfo(String indexUUID, String indexName, long creationDateMillis) {
            this.indexUUID = indexUUID;
            this.indexName = indexName;
            this.creationDateMillis = creationDateMillis;
            this.nodeIds = new ArrayList<String>();
        }

        public List<String> getNodeIds() {
            return this.nodeIds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregatedDanglingIndexInfo that = (AggregatedDanglingIndexInfo)o;
            return this.creationDateMillis == that.creationDateMillis && this.indexUUID.equals(that.indexUUID) && this.indexName.equals(that.indexName) && this.nodeIds.equals(that.nodeIds);
        }

        public int hashCode() {
            return Objects.hash(this.indexUUID, this.indexName, this.creationDateMillis, this.nodeIds);
        }

        public String toString() {
            return String.format(Locale.ROOT, "AggregatedDanglingIndexInfo{indexUUID='%s', indexName='%s', creationDateMillis=%d, nodeIds=%s}", this.indexUUID, this.indexName, this.creationDateMillis, this.nodeIds);
        }
    }
}

