/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.action.StepListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.SnapshotsInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.set.Sets;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.util.CollectionUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.snapshots.IndexShardSnapshotStatus;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.IndexId;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoriesService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.Repository;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.RepositoryData;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.Snapshot;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotId;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotInfo;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotShardFailure;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotState;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotsService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportSnapshotsStatusAction
extends TransportClusterManagerNodeAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private static final Logger logger = LogManager.getLogger(TransportSnapshotsStatusAction.class);
    private final RepositoriesService repositoriesService;
    private final TransportNodesSnapshotsStatus transportNodesSnapshotsStatus;

    @Inject
    public TransportSnapshotsStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, TransportNodesSnapshotsStatus transportNodesSnapshotsStatus, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters, SnapshotsStatusRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
        this.transportNodesSnapshotsStatus = transportNodesSnapshotsStatus;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected SnapshotsStatusResponse read(StreamInput in) throws IOException {
        return new SnapshotsStatusResponse(in);
    }

    @Override
    protected void clusterManagerOperation(SnapshotsStatusRequest request, ClusterState state, ActionListener<SnapshotsStatusResponse> listener) throws Exception {
        SnapshotsInProgress snapshotsInProgress = state.custom("snapshots", SnapshotsInProgress.EMPTY);
        List<SnapshotsInProgress.Entry> currentSnapshots = SnapshotsService.currentSnapshots(snapshotsInProgress, request.repository(), Arrays.asList(request.snapshots()));
        if (currentSnapshots.isEmpty()) {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, listener);
            return;
        }
        HashSet<String> nodesIds = new HashSet<String>();
        for (SnapshotsInProgress.Entry entry : currentSnapshots) {
            for (SnapshotsInProgress.ShardSnapshotStatus status : entry.shards().values()) {
                if (status.nodeId() == null) continue;
                nodesIds.add(status.nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            Snapshot[] snapshots = new Snapshot[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshots[i] = currentSnapshots.get(i).snapshot();
            }
            this.transportNodesSnapshotsStatus.execute((TransportNodesSnapshotsStatus.Request)new TransportNodesSnapshotsStatus.Request(nodesIds.toArray(Strings.EMPTY_ARRAY)).snapshots(snapshots).timeout(request.clusterManagerNodeTimeout()), ActionListener.wrap(nodeSnapshotStatuses -> this.threadPool.generic().execute(ActionRunnable.wrap(listener, l -> this.buildResponse(snapshotsInProgress, request, currentSnapshots, (TransportNodesSnapshotsStatus.NodesSnapshotStatus)nodeSnapshotStatuses, (ActionListener<SnapshotsStatusResponse>)l))), listener::onFailure));
        } else {
            this.buildResponse(snapshotsInProgress, request, currentSnapshots, null, listener);
        }
    }

    private void buildResponse(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotsInProgress.Entry> currentSnapshotEntries, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses, ActionListener<SnapshotsStatusResponse> listener) {
        String repositoryName;
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        HashSet<String> currentSnapshotNames = new HashSet<String>();
        if (!currentSnapshotEntries.isEmpty()) {
            Map nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : new HashMap();
            for (SnapshotsInProgress.Entry entry : currentSnapshotEntries) {
                currentSnapshotNames.add(entry.snapshot().getSnapshotId().getName());
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                Map indexIdLookup = null;
                for (Map.Entry<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shardEntry : entry.shards().entrySet()) {
                    SnapshotIndexShardStatus shardStatus;
                    SnapshotIndexShardStage stage;
                    SnapshotIndexShardStatus shardStatus2;
                    Map<ShardId, SnapshotIndexShardStatus> shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotsInProgress.ShardSnapshotStatus status = shardEntry.getValue();
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)nodeSnapshotStatusMap.get(status.nodeId())) != null && (shardStatues = nodeStatus.status().get(entry.snapshot())) != null && (shardStatus2 = shardStatues.get(shardEntry.getKey())) != null) {
                        if (shardStatus2.getStage() == SnapshotIndexShardStage.DONE && shardEntry.getValue().state() != SnapshotsInProgress.ShardState.SUCCESS) {
                            shardStatus2 = new SnapshotIndexShardStatus(shardEntry.getKey(), SnapshotIndexShardStage.FINALIZE, shardStatus2.getStats(), shardStatus2.getNodeId(), shardStatus2.getFailure());
                        }
                        shardStatusBuilder.add(shardStatus2);
                        continue;
                    }
                    switch (shardEntry.getValue().state()) {
                        case FAILED: 
                        case ABORTED: 
                        case MISSING: {
                            stage = SnapshotIndexShardStage.FAILURE;
                            break;
                        }
                        case INIT: 
                        case WAITING: 
                        case QUEUED: {
                            stage = SnapshotIndexShardStage.STARTED;
                            break;
                        }
                        case SUCCESS: {
                            stage = SnapshotIndexShardStage.DONE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown snapshot state " + shardEntry.getValue().state());
                        }
                    }
                    if (stage == SnapshotIndexShardStage.DONE) {
                        if (indexIdLookup == null) {
                            indexIdLookup = entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()));
                        }
                        ShardId shardId = shardEntry.getKey();
                        shardStatus = new SnapshotIndexShardStatus(shardId, this.repositoriesService.repository(entry.repository()).getShardSnapshotStatus(entry.snapshot().getSnapshotId(), (IndexId)indexIdLookup.get(shardId.getIndexName()), shardId).asCopy());
                    } else {
                        shardStatus = new SnapshotIndexShardStatus(shardEntry.getKey(), stage);
                    }
                    shardStatusBuilder.add(shardStatus);
                }
                builder.add(new SnapshotStatus(entry.snapshot(), entry.state(), Collections.unmodifiableList(shardStatusBuilder), entry.includeGlobalState(), entry.startTime(), Math.max(this.threadPool.absoluteTimeInMillis() - entry.startTime(), 0L)));
            }
        }
        if (Strings.hasText(repositoryName = request.repository()) && !CollectionUtils.isEmpty(request.snapshots())) {
            this.loadRepositoryData(snapshotsInProgress, request, builder, currentSnapshotNames, repositoryName, listener);
        } else {
            listener.onResponse(new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }
    }

    private void loadRepositoryData(SnapshotsInProgress snapshotsInProgress, SnapshotsStatusRequest request, List<SnapshotStatus> builder, Set<String> currentSnapshotNames, String repositoryName, ActionListener<SnapshotsStatusResponse> listener) {
        HashSet<String> requestedSnapshotNames = Sets.newHashSet(request.snapshots());
        StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
        this.repositoriesService.getRepositoryData(repositoryName, repositoryDataListener);
        repositoryDataListener.whenComplete(repositoryData -> {
            Map matchedSnapshotIds = repositoryData.getSnapshotIds().stream().filter(s -> requestedSnapshotNames.contains(s.getName())).collect(Collectors.toMap(SnapshotId::getName, Function.identity()));
            for (String snapshotName : request.snapshots()) {
                SnapshotsInProgress.State state;
                if (currentSnapshotNames.contains(snapshotName)) continue;
                SnapshotId snapshotId = (SnapshotId)matchedSnapshotIds.get(snapshotName);
                if (snapshotId == null) {
                    if (request.ignoreUnavailable()) {
                        logger.debug("snapshot status request ignoring snapshot [{}], not found in repository [{}]", (Object)snapshotName, (Object)repositoryName);
                        continue;
                    }
                    throw new SnapshotMissingException(repositoryName, snapshotName);
                }
                SnapshotInfo snapshotInfo = this.snapshot(snapshotsInProgress, repositoryName, snapshotId);
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                if (!snapshotInfo.state().completed()) continue;
                Map<ShardId, IndexShardSnapshotStatus> shardStatuses = this.snapshotShards(repositoryName, (RepositoryData)repositoryData, snapshotInfo);
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardStatus : shardStatuses.entrySet()) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardStatus.getValue().asCopy();
                    shardStatusBuilder.add(new SnapshotIndexShardStatus(shardStatus.getKey(), lastSnapshotStatus));
                }
                switch (snapshotInfo.state()) {
                    case FAILED: {
                        state = SnapshotsInProgress.State.FAILED;
                        break;
                    }
                    case SUCCESS: 
                    case PARTIAL: {
                        state = SnapshotsInProgress.State.SUCCESS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown snapshot state " + snapshotInfo.state());
                    }
                }
                long startTime = snapshotInfo.startTime();
                long endTime = snapshotInfo.endTime();
                assert (endTime >= startTime || endTime == 0L && !snapshotInfo.state().completed()) : "Inconsistent timestamps found in SnapshotInfo [" + snapshotInfo + "]";
                builder.add(new SnapshotStatus(new Snapshot(repositoryName, snapshotId), state, Collections.unmodifiableList(shardStatusBuilder), snapshotInfo.includeGlobalState(), startTime, (endTime == 0L ? this.threadPool.absoluteTimeInMillis() : endTime) - startTime));
            }
            listener.onResponse(new SnapshotsStatusResponse(Collections.unmodifiableList(builder)));
        }, listener::onFailure);
    }

    private SnapshotInfo snapshot(SnapshotsInProgress snapshotsInProgress, String repositoryName, SnapshotId snapshotId) {
        List<SnapshotsInProgress.Entry> entries = SnapshotsService.currentSnapshots(snapshotsInProgress, repositoryName, Collections.singletonList(snapshotId.getName()));
        if (!entries.isEmpty()) {
            return new SnapshotInfo(entries.iterator().next());
        }
        return this.repositoriesService.repository(repositoryName).getSnapshotInfo(snapshotId);
    }

    private Map<ShardId, IndexShardSnapshotStatus> snapshotShards(String repositoryName, RepositoryData repositoryData, SnapshotInfo snapshotInfo) throws IOException {
        Repository repository = this.repositoriesService.repository(repositoryName);
        HashMap<ShardId, IndexShardSnapshotStatus> shardStatus = new HashMap<ShardId, IndexShardSnapshotStatus>();
        for (String index : snapshotInfo.indices()) {
            IndexId indexId = repositoryData.resolveIndexId(index);
            IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData(repositoryData, snapshotInfo.snapshotId(), indexId);
            if (indexMetadata == null) continue;
            int numberOfShards = indexMetadata.getNumberOfShards();
            for (int i = 0; i < numberOfShards; ++i) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
                SnapshotShardFailure shardFailure = TransportSnapshotsStatusAction.findShardFailure(snapshotInfo.shardFailures(), shardId);
                if (shardFailure != null) {
                    shardStatus.put(shardId, IndexShardSnapshotStatus.newFailed(shardFailure.reason()));
                    continue;
                }
                IndexShardSnapshotStatus shardSnapshotStatus = snapshotInfo.state() == SnapshotState.FAILED ? IndexShardSnapshotStatus.newFailed("skipped") : repository.getShardSnapshotStatus(snapshotInfo.snapshotId(), indexId, shardId);
                shardStatus.put(shardId, shardSnapshotStatus);
            }
        }
        return Collections.unmodifiableMap(shardStatus);
    }

    private static SnapshotShardFailure findShardFailure(List<SnapshotShardFailure> shardFailures, ShardId shardId) {
        for (SnapshotShardFailure shardFailure : shardFailures) {
            if (!shardId.getIndexName().equals(shardFailure.index()) || shardId.getId() != shardFailure.shardId()) continue;
            return shardFailure;
        }
        return null;
    }
}

