/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.restore;

import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.RestoreInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.RestoreInfo;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.RestoreService;

public class RestoreClusterStateListener<T extends ActionResponse>
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(RestoreClusterStateListener.class);
    private final ClusterService clusterService;
    private final String uuid;
    private final String restoreIdentifier;
    private final ActionListener<T> listener;
    private final Function<RestoreInfo, T> actionResponseFactory;

    private RestoreClusterStateListener(ClusterService clusterService, RestoreService.RestoreCompletionResponse response, ActionListener<T> listener, Function<RestoreInfo, T> actionResponseFactory) {
        this.clusterService = clusterService;
        this.uuid = response.getUuid();
        this.restoreIdentifier = response.getSnapshot() != null ? response.getSnapshot().getSnapshotId().getName() : "remote_store";
        this.listener = listener;
        this.actionResponseFactory = actionResponseFactory;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent changedEvent) {
        RestoreInProgress.Entry prevEntry = RestoreService.restoreInProgress(changedEvent.previousState(), this.uuid);
        RestoreInProgress.Entry newEntry = RestoreService.restoreInProgress(changedEvent.state(), this.uuid);
        if (prevEntry == null) {
            this.clusterService.removeListener(this);
            this.listener.onResponse((ActionResponse)this.actionResponseFactory.apply(null));
        } else if (newEntry == null) {
            this.clusterService.removeListener(this);
            Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = prevEntry.shards();
            assert (prevEntry.state().completed()) : "expected completed snapshot/remote store restore state but was " + prevEntry.state();
            assert (RestoreService.completed(shards)) : "expected all restore entries to be completed";
            RestoreInfo ri = new RestoreInfo(this.restoreIdentifier, prevEntry.indices(), shards.size(), shards.size() - RestoreService.failedShards(shards));
            ActionResponse response = (ActionResponse)this.actionResponseFactory.apply(ri);
            logger.debug("restore of [{}] completed", (Object)this.restoreIdentifier);
            this.listener.onResponse(response);
        } else {
            logger.debug("restore not completed yet, wait for next cluster state update");
        }
    }

    public static <T extends ActionResponse> void createAndRegisterListener(ClusterService clusterService, RestoreService.RestoreCompletionResponse response, ActionListener<T> listener, Function<RestoreInfo, T> actionResponseFactory) {
        clusterService.addListener(new RestoreClusterStateListener<T>(clusterService, response, listener, actionResponseFactory));
    }
}

