/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.WeightedRouting;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParserUtils;

public class ClusterGetWeightedRoutingResponse
extends ActionResponse
implements ToXContentObject {
    private static final String WEIGHTS = "weights";
    private long version;
    private final Boolean discoveredClusterManager;
    private static final String DISCOVERED_CLUSTER_MANAGER = "discovered_cluster_manager";
    private final WeightedRouting weightedRouting;

    public WeightedRouting getWeightedRouting() {
        return this.weightedRouting;
    }

    public long getVersion() {
        return this.version;
    }

    public Boolean getDiscoveredClusterManager() {
        return this.discoveredClusterManager;
    }

    ClusterGetWeightedRoutingResponse() {
        this.weightedRouting = null;
        this.discoveredClusterManager = null;
    }

    public ClusterGetWeightedRoutingResponse(WeightedRouting weightedRouting, Boolean discoveredClusterManager, long version) {
        this.discoveredClusterManager = discoveredClusterManager;
        this.weightedRouting = weightedRouting;
        this.version = version;
    }

    ClusterGetWeightedRoutingResponse(StreamInput in) throws IOException {
        if (in.available() != 0) {
            this.weightedRouting = new WeightedRouting(in);
            this.version = in.readLong();
            this.discoveredClusterManager = in.readOptionalBoolean();
        } else {
            this.weightedRouting = null;
            this.discoveredClusterManager = null;
        }
    }

    public WeightedRouting weights() {
        return this.weightedRouting;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.weightedRouting != null) {
            this.weightedRouting.writeTo(out);
            out.writeLong(this.version);
        }
        if (this.discoveredClusterManager != null) {
            out.writeOptionalBoolean(this.discoveredClusterManager);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weightedRouting != null) {
            builder.startObject(WEIGHTS);
            for (Map.Entry<String, Double> entry : this.weightedRouting.weights().entrySet()) {
                builder.field(entry.getKey(), entry.getValue().toString());
            }
            builder.endObject();
            builder.field("_version", this.version);
            if (this.discoveredClusterManager != null) {
                builder.field(DISCOVERED_CLUSTER_MANAGER, this.discoveredClusterManager);
            }
        }
        builder.endObject();
        return builder;
    }

    public static ClusterGetWeightedRoutingResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        String attrKey = null;
        Boolean discoveredClusterManager = null;
        HashMap<String, Double> weights = new HashMap<String, Double>();
        long version = -2L;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                if (fieldName != null && (fieldName.equals("_version") || fieldName.equals(DISCOVERED_CLUSTER_MANAGER))) continue;
                if (fieldName == null || !fieldName.equals(WEIGHTS)) {
                    throw new OpenSearchParseException("failed to parse weighted routing request object", fieldName);
                }
                String weightsAttr = parser.currentName();
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new OpenSearchParseException("failed to parse weighted routing request object [{}], expected object", weightsAttr);
                }
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        attrKey = parser.currentName();
                        continue;
                    }
                    if (token == XContentParser.Token.VALUE_STRING) {
                        String attrValue = parser.text();
                        if (attrKey == null) continue;
                        weights.put(attrKey, Double.parseDouble(attrValue));
                        continue;
                    }
                    throw new OpenSearchParseException("failed to parse weighted routing request attribute [{}]", attrKey);
                }
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER && fieldName != null && fieldName.equals("_version")) {
                version = parser.longValue();
                continue;
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN && fieldName != null && fieldName.equals(DISCOVERED_CLUSTER_MANAGER)) {
                discoveredClusterManager = Boolean.parseBoolean(parser.text());
                continue;
            }
            throw new OpenSearchParseException("failed to parse weighted routing request", new Object[0]);
        }
        WeightedRouting weightedRouting = new WeightedRouting("", weights);
        return new ClusterGetWeightedRoutingResponse(weightedRouting, discoveredClusterManager, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterGetWeightedRoutingResponse that = (ClusterGetWeightedRoutingResponse)o;
        return this.weightedRouting.equals(that.weightedRouting) && this.discoveredClusterManager.equals(that.discoveredClusterManager);
    }

    public int hashCode() {
        return Objects.hash(this.weightedRouting, this.discoveredClusterManager);
    }
}

