/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.hotthreads;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.jvm.HotThreads;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportNodesHotThreadsAction
extends TransportNodesAction<NodesHotThreadsRequest, NodesHotThreadsResponse, NodeRequest, NodeHotThreads> {
    @Inject
    public TransportNodesHotThreadsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:monitor/nodes/hot_threads", threadPool, clusterService, transportService, actionFilters, NodesHotThreadsRequest::new, NodeRequest::new, "generic", NodeHotThreads.class);
    }

    @Override
    protected NodesHotThreadsResponse newResponse(NodesHotThreadsRequest request, List<NodeHotThreads> responses, List<FailedNodeException> failures) {
        return new NodesHotThreadsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(NodesHotThreadsRequest request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeHotThreads newNodeResponse(StreamInput in) throws IOException {
        return new NodeHotThreads(in);
    }

    @Override
    protected NodeHotThreads nodeOperation(NodeRequest request) {
        HotThreads hotThreads = new HotThreads().busiestThreads(request.request.threads).type(request.request.type).interval(request.request.interval).threadElementsSnapshotCount(request.request.snapshots).ignoreIdleThreads(request.request.ignoreIdleThreads);
        try {
            return new NodeHotThreads(this.clusterService.localNode(), hotThreads.detect());
        }
        catch (Exception e) {
            throw new OpenSearchException("failed to detect hot threads", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        NodesHotThreadsRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesHotThreadsRequest(in);
        }

        NodeRequest(NodesHotThreadsRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

