/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.NeighborArray;

public final class OnHeapHnswGraph
extends HnswGraph
implements Accountable {
    private int numLevels = 1;
    private int entryNode = -1;
    private final List<NeighborArray> graphLevel0 = new ArrayList<NeighborArray>();
    private final List<TreeMap<Integer, NeighborArray>> graphUpperLevels;
    private final int nsize;
    private final int nsize0;
    private int upto;
    private NeighborArray cur;

    OnHeapHnswGraph(int M) {
        this.nsize = M + 1;
        this.nsize0 = M * 2 + 1;
        this.graphUpperLevels = new ArrayList<TreeMap<Integer, NeighborArray>>(this.numLevels);
        this.graphUpperLevels.add(null);
    }

    public NeighborArray getNeighbors(int level, int node) {
        if (level == 0) {
            return this.graphLevel0.get(node);
        }
        TreeMap<Integer, NeighborArray> levelMap = this.graphUpperLevels.get(level);
        assert (levelMap.containsKey(node));
        return levelMap.get(node);
    }

    @Override
    public int size() {
        return this.graphLevel0.size();
    }

    public void addNode(int level, int node) {
        if (this.entryNode == -1) {
            this.entryNode = node;
        }
        if (level > 0) {
            if (level >= this.numLevels) {
                for (int i = this.numLevels; i <= level; ++i) {
                    this.graphUpperLevels.add(new TreeMap());
                }
                this.numLevels = level + 1;
                this.entryNode = node;
            }
            this.graphUpperLevels.get(level).put(node, new NeighborArray(this.nsize, true));
        } else {
            while (node >= this.graphLevel0.size()) {
                this.graphLevel0.add(new NeighborArray(this.nsize0, true));
            }
        }
    }

    @Override
    public void seek(int level, int targetNode) {
        this.cur = this.getNeighbors(level, targetNode);
        this.upto = -1;
    }

    @Override
    public int nextNeighbor() {
        if (++this.upto < this.cur.size()) {
            return this.cur.node[this.upto];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int numLevels() {
        return this.numLevels;
    }

    @Override
    public int entryNode() {
        return this.entryNode;
    }

    @Override
    public HnswGraph.NodesIterator getNodesOnLevel(int level) {
        if (level == 0) {
            return new HnswGraph.ArrayNodesIterator(this.size());
        }
        return new HnswGraph.CollectionNodesIterator(this.graphUpperLevels.get(level).keySet());
    }

    @Override
    public long ramBytesUsed() {
        long neighborArrayBytes0 = this.nsize0 * 8 + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2 + 12;
        long neighborArrayBytes = this.nsize * 8 + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2 + 12;
        long total = 0L;
        for (int l = 0; l < this.numLevels; ++l) {
            if (l == 0) {
                total += (long)this.graphLevel0.size() * neighborArrayBytes0 + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
                continue;
            }
            long numNodesOnLevel = this.graphUpperLevels.get(l).size();
            total += numNodesOnLevel * (3L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4L + 1L) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            total += numNodesOnLevel * neighborArrayBytes;
        }
        return total;
    }
}

