/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRefIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.UnicodeUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automaton;

@Deprecated
public final class DaciukMihovAutomatonBuilder {
    @Deprecated
    public static final int MAX_TERM_LENGTH = 1000;
    private HashMap<State, State> stateRegistry = new HashMap();
    private final State root = new State();
    private BytesRefBuilder previous;

    private DaciukMihovAutomatonBuilder() {
    }

    private boolean setPrevious(BytesRef current) {
        if (this.previous == null) {
            this.previous = new BytesRefBuilder();
        }
        this.previous.copyBytes(current);
        return true;
    }

    private static int convert(Automaton.Builder a, State s, IdentityHashMap<State, Integer> visited) {
        Integer converted = visited.get(s);
        if (converted != null) {
            return converted;
        }
        converted = a.createState();
        a.setAccept(converted, s.is_final);
        visited.put(s, converted);
        int i = 0;
        int[] labels = s.labels;
        for (State target : s.states) {
            a.addTransition(converted, DaciukMihovAutomatonBuilder.convert(a, target, visited), labels[i++]);
        }
        return converted;
    }

    private Automaton completeAndConvert() {
        if (this.stateRegistry == null) {
            throw new IllegalStateException();
        }
        if (this.root.hasChildren()) {
            this.replaceOrRegister(this.root);
        }
        this.stateRegistry = null;
        Automaton.Builder a = new Automaton.Builder();
        DaciukMihovAutomatonBuilder.convert(a, this.root, new IdentityHashMap<State, Integer>());
        return a.finish();
    }

    @Deprecated
    public static Automaton build(Collection<BytesRef> input) {
        return DaciukMihovAutomatonBuilder.build(input, false);
    }

    static Automaton build(Collection<BytesRef> input, boolean asBinary) {
        DaciukMihovAutomatonBuilder builder = new DaciukMihovAutomatonBuilder();
        for (BytesRef b : input) {
            builder.add(b, asBinary);
        }
        return builder.completeAndConvert();
    }

    static Automaton build(BytesRefIterator input, boolean asBinary) throws IOException {
        DaciukMihovAutomatonBuilder builder = new DaciukMihovAutomatonBuilder();
        BytesRef b = input.next();
        while (b != null) {
            builder.add(b, asBinary);
            b = input.next();
        }
        return builder.completeAndConvert();
    }

    private void add(BytesRef current, boolean asBinary) {
        State next;
        int pos;
        if (current.length > 1000) {
            throw new IllegalArgumentException("This builder doesn't allow terms that are larger than 1000 characters, got " + current);
        }
        assert (this.stateRegistry != null) : "Automaton already built.";
        assert (this.previous == null || this.previous.get().compareTo(current) <= 0) : "Input must be in sorted UTF-8 order: " + this.previous.get() + " >= " + current;
        assert (this.setPrevious(current));
        UnicodeUtil.UTF8CodePoint codePoint = null;
        byte[] bytes = current.bytes;
        int max = current.offset + current.length;
        State state = this.root;
        if (asBinary) {
            for (pos = current.offset; pos < max && (next = state.lastChild(bytes[pos] & 0xFF)) != null; ++pos) {
                state = next;
            }
        } else {
            while (pos < max) {
                codePoint = UnicodeUtil.codePointAt(bytes, pos, codePoint);
                next = state.lastChild(codePoint.codePoint);
                if (next != null) {
                    state = next;
                    pos += codePoint.numBytes;
                    continue;
                }
                break;
            }
        }
        if (state.hasChildren()) {
            this.replaceOrRegister(state);
        }
        if (asBinary) {
            while (pos < max) {
                state = state.newState(bytes[pos] & 0xFF);
                ++pos;
            }
        } else {
            while (pos < max) {
                codePoint = UnicodeUtil.codePointAt(bytes, pos, codePoint);
                state = state.newState(codePoint.codePoint);
                pos += codePoint.numBytes;
            }
        }
        state.is_final = true;
    }

    private void replaceOrRegister(State state) {
        State registered;
        State child = state.lastChild();
        if (child.hasChildren()) {
            this.replaceOrRegister(child);
        }
        if ((registered = this.stateRegistry.get(child)) != null) {
            state.replaceLastChild(registered);
        } else {
            this.stateRegistry.put(child, child);
        }
    }

    private static final class State {
        private static final int[] NO_LABELS = new int[0];
        private static final State[] NO_STATES = new State[0];
        int[] labels = NO_LABELS;
        State[] states = NO_STATES;
        boolean is_final;

        private State() {
        }

        State getState(int label) {
            int index = Arrays.binarySearch(this.labels, label);
            return index >= 0 ? this.states[index] : null;
        }

        public boolean equals(Object obj) {
            State other = (State)obj;
            return this.is_final == other.is_final && Arrays.equals(this.labels, other.labels) && State.referenceEquals(this.states, other.states);
        }

        public int hashCode() {
            int hash = this.is_final ? 1 : 0;
            hash ^= hash * 31 + this.labels.length;
            for (int c : this.labels) {
                hash ^= hash * 31 + c;
            }
            for (State s : this.states) {
                hash ^= System.identityHashCode(s);
            }
            return hash;
        }

        boolean hasChildren() {
            return this.labels.length > 0;
        }

        State newState(int label) {
            assert (Arrays.binarySearch(this.labels, label) < 0) : "State already has transition labeled: " + label;
            this.labels = ArrayUtil.growExact(this.labels, this.labels.length + 1);
            this.states = ArrayUtil.growExact(this.states, this.states.length + 1);
            this.labels[this.labels.length - 1] = label;
            State state = new State();
            this.states[this.states.length - 1] = state;
            return state;
        }

        State lastChild() {
            assert (this.hasChildren()) : "No outgoing transitions.";
            return this.states[this.states.length - 1];
        }

        State lastChild(int label) {
            int index = this.labels.length - 1;
            State s = null;
            if (index >= 0 && this.labels[index] == label) {
                s = this.states[index];
            }
            assert (s == this.getState(label));
            return s;
        }

        void replaceLastChild(State state) {
            assert (this.hasChildren()) : "No outgoing transitions.";
            this.states[this.states.length - 1] = state;
        }

        private static boolean referenceEquals(Object[] a1, Object[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

