/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisiPriorityQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisiWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MaxScoreSumPropagator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;

class BlockMaxMaxscoreScorer
extends Scorer {
    private int doc = -1;
    private int upTo = -1;
    private final DisiPriorityQueue essentialsScorers;
    private final DisiWrapper[] allScorers;
    private int firstEssentialScorerIndex;
    private double nonEssentialMaxScoreSum;
    private final long cost;
    private final MaxScoreSumPropagator maxScoreSumPropagator;
    private float minCompetitiveScore = 0.0f;
    private double score;

    public BlockMaxMaxscoreScorer(Weight weight, List<Scorer> scorers) throws IOException {
        super(weight);
        this.allScorers = new DisiWrapper[scorers.size()];
        this.essentialsScorers = new DisiPriorityQueue(scorers.size());
        this.firstEssentialScorerIndex = 0;
        long cost = 0L;
        for (int i = 0; i < scorers.size(); ++i) {
            DisiWrapper w = new DisiWrapper(scorers.get(i));
            cost += w.cost;
            this.allScorers[i] = w;
        }
        this.cost = cost;
        this.maxScoreSumPropagator = new MaxScoreSumPropagator(scorers);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int docID() {
                return BlockMaxMaxscoreScorer.this.doc;
            }

            @Override
            public int nextDoc() throws IOException {
                return this.advance(BlockMaxMaxscoreScorer.this.doc + 1);
            }

            @Override
            public int advance(int target) throws IOException {
                DisiWrapper top;
                while (true) {
                    if (target > BlockMaxMaxscoreScorer.this.upTo) {
                        this.updateMaxScoresAndLists(target);
                    } else {
                        this.movePotentiallyNonCompetitiveScorers();
                    }
                    assert (target <= BlockMaxMaxscoreScorer.this.upTo);
                    top = BlockMaxMaxscoreScorer.this.essentialsScorers.top();
                    if (top == null) {
                        if (BlockMaxMaxscoreScorer.this.upTo == Integer.MAX_VALUE) {
                            BlockMaxMaxscoreScorer.this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        target = BlockMaxMaxscoreScorer.this.upTo + 1;
                        continue;
                    }
                    while (top.doc < target) {
                        top.doc = top.iterator.advance(target);
                        top = BlockMaxMaxscoreScorer.this.essentialsScorers.updateTop();
                    }
                    if (top.doc == Integer.MAX_VALUE) {
                        BlockMaxMaxscoreScorer.this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    if (top.doc <= BlockMaxMaxscoreScorer.this.upTo) break;
                    target = BlockMaxMaxscoreScorer.this.upTo + 1;
                }
                BlockMaxMaxscoreScorer.this.doc = top.doc;
                return BlockMaxMaxscoreScorer.this.doc;
            }

            private void movePotentiallyNonCompetitiveScorers() {
                boolean removedEssentialScorer = false;
                while (BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex < BlockMaxMaxscoreScorer.this.allScorers.length && BlockMaxMaxscoreScorer.this.maxScoreSumPropagator.scoreSumUpperBound(BlockMaxMaxscoreScorer.this.nonEssentialMaxScoreSum + (double)BlockMaxMaxscoreScorer.this.allScorers[BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex].maxScore) < BlockMaxMaxscoreScorer.this.minCompetitiveScore) {
                    DisiWrapper nextLeastContributingScorer = BlockMaxMaxscoreScorer.this.allScorers[BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex++];
                    BlockMaxMaxscoreScorer.this.nonEssentialMaxScoreSum += (double)nextLeastContributingScorer.maxScore;
                    removedEssentialScorer = true;
                }
                if (removedEssentialScorer) {
                    BlockMaxMaxscoreScorer.this.essentialsScorers.clear();
                    BlockMaxMaxscoreScorer.this.essentialsScorers.addAll(BlockMaxMaxscoreScorer.this.allScorers, BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex, BlockMaxMaxscoreScorer.this.allScorers.length - BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex);
                }
            }

            private void updateMaxScoresAndLists(int target) throws IOException {
                assert (target > BlockMaxMaxscoreScorer.this.upTo);
                this.updateUpToAndMaxScore(target);
                this.repartitionLists();
            }

            private void updateUpToAndMaxScore(int target) throws IOException {
                BlockMaxMaxscoreScorer.this.upTo = -1;
                for (DisiWrapper w : BlockMaxMaxscoreScorer.this.allScorers) {
                    BlockMaxMaxscoreScorer.this.upTo = Math.max(w.scorer.advanceShallow(Math.max(w.doc, target)), BlockMaxMaxscoreScorer.this.upTo);
                }
                assert (target <= BlockMaxMaxscoreScorer.this.upTo);
                for (DisiWrapper w : BlockMaxMaxscoreScorer.this.allScorers) {
                    assert (w.doc <= BlockMaxMaxscoreScorer.this.upTo);
                    w.maxScore = w.scorer.getMaxScore(BlockMaxMaxscoreScorer.this.upTo);
                }
            }

            private void repartitionLists() {
                BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex = 0;
                Arrays.sort(BlockMaxMaxscoreScorer.this.allScorers, Comparator.comparingDouble(scorer -> scorer.maxScore));
                BlockMaxMaxscoreScorer.this.nonEssentialMaxScoreSum = 0.0;
                for (DisiWrapper w : BlockMaxMaxscoreScorer.this.allScorers) {
                    if (BlockMaxMaxscoreScorer.this.maxScoreSumPropagator.scoreSumUpperBound(BlockMaxMaxscoreScorer.this.nonEssentialMaxScoreSum + (double)w.maxScore) >= BlockMaxMaxscoreScorer.this.minCompetitiveScore) break;
                    ++BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex;
                    BlockMaxMaxscoreScorer.this.nonEssentialMaxScoreSum += (double)w.maxScore;
                }
                BlockMaxMaxscoreScorer.this.essentialsScorers.clear();
                BlockMaxMaxscoreScorer.this.essentialsScorers.addAll(BlockMaxMaxscoreScorer.this.allScorers, BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex, BlockMaxMaxscoreScorer.this.allScorers.length - BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex);
            }

            @Override
            public long cost() {
                return BlockMaxMaxscoreScorer.this.cost;
            }
        };
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                BlockMaxMaxscoreScorer.this.score = 0.0;
                DisiWrapper w = BlockMaxMaxscoreScorer.this.essentialsScorers.topList();
                while (w != null) {
                    BlockMaxMaxscoreScorer.this.score += (double)w.scorer.score();
                    w = w.next;
                }
                double docScoreUpperBound = BlockMaxMaxscoreScorer.this.score + BlockMaxMaxscoreScorer.this.nonEssentialMaxScoreSum;
                if (BlockMaxMaxscoreScorer.this.maxScoreSumPropagator.scoreSumUpperBound(docScoreUpperBound) < BlockMaxMaxscoreScorer.this.minCompetitiveScore) {
                    return false;
                }
                for (int i = 0; i < BlockMaxMaxscoreScorer.this.firstEssentialScorerIndex; ++i) {
                    DisiWrapper w2 = BlockMaxMaxscoreScorer.this.allScorers[i];
                    if (w2.doc < BlockMaxMaxscoreScorer.this.doc) {
                        w2.doc = w2.iterator.advance(BlockMaxMaxscoreScorer.this.doc);
                    }
                    if (w2.doc != BlockMaxMaxscoreScorer.this.doc) continue;
                    BlockMaxMaxscoreScorer.this.score += (double)BlockMaxMaxscoreScorer.this.allScorers[i].scorer.score();
                }
                return BlockMaxMaxscoreScorer.this.score() >= BlockMaxMaxscoreScorer.this.minCompetitiveScore;
            }

            @Override
            public float matchCost() {
                return BlockMaxMaxscoreScorer.this.allScorers.length;
            }
        };
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        this.maxScoreSumPropagator.advanceShallow(target);
        int result = Integer.MAX_VALUE;
        for (DisiWrapper s : this.allScorers) {
            if (s.doc >= target) continue;
            result = Math.min(result, s.scorer.advanceShallow(target));
        }
        return result;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreSumPropagator.getMaxScore(upTo);
    }

    @Override
    public float score() throws IOException {
        return (float)this.score;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public final Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> matchingChildren = new ArrayList<Scorable.ChildScorable>();
        for (DisiWrapper s : this.allScorers) {
            if (s.doc != this.doc) continue;
            matchingChildren.add(new Scorable.ChildScorable(s.scorer, "SHOULD"));
        }
        return matchingChildren;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        assert (minScore >= 0.0f);
        this.minCompetitiveScore = minScore;
        this.maxScoreSumPropagator.setMinCompetitiveScore(minScore);
    }
}

