/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FloatVectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.valuesource.VectorFieldFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;

public class FloatKnnVectorFieldSource
extends ValueSource {
    private final String fieldName;

    public FloatKnnVectorFieldSource(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FloatVectorValues vectorValues = readerContext.reader().getFloatVectorValues(this.fieldName);
        if (vectorValues == null) {
            throw new IllegalArgumentException("no float vector value is indexed for field '" + this.fieldName + "'");
        }
        return new VectorFieldFunction(this){

            @Override
            public float[] floatVectorVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    return vectorValues.vectorValue();
                }
                return null;
            }

            @Override
            protected DocIdSetIterator getVectorIterator() {
                return vectorValues;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatKnnVectorFieldSource other = (FloatKnnVectorFieldSource)o;
        return Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().hashCode(), this.fieldName);
    }

    @Override
    public String description() {
        return "FloatKnnVectorFieldSource(" + this.fieldName + ")";
    }
}

