/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.document;

import java.util.function.Function;
import java.util.function.Predicate;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.ShapeField;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.SpatialQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Geometry;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.XYEncodingUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.XYGeometry;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.NumericUtils;

final class XYShapeQuery
extends SpatialQuery {
    XYShapeQuery(String field, ShapeField.QueryRelation queryRelation, XYGeometry ... geometries) {
        super(field, queryRelation, geometries);
    }

    @Override
    protected Component2D createComponent2D(Geometry ... geometries) {
        return XYGeometry.create((XYGeometry[])geometries);
    }

    static SpatialQuery.SpatialVisitor getSpatialVisitor(final Component2D component2D) {
        return new SpatialQuery.SpatialVisitor(){

            @Override
            protected PointValues.Relation relate(byte[] minTriangle, byte[] maxTriangle) {
                double minY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, 0));
                double minX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, 4));
                double maxY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, 8));
                double maxX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, 12));
                return component2D.relate(minX, maxX, minY, maxY);
            }

            @Override
            protected Predicate<byte[]> intersects() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double y = XYEncodingUtils.decode(scratchTriangle.aY);
                            double x = XYEncodingUtils.decode(scratchTriangle.aX);
                            return component2D.contains(x, y);
                        }
                        case LINE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            return component2D.intersectsLine(aX, aY, bX, bY);
                        }
                        case TRIANGLE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                            double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                            return component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }

            @Override
            protected Predicate<byte[]> within() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double y = XYEncodingUtils.decode(scratchTriangle.aY);
                            double x = XYEncodingUtils.decode(scratchTriangle.aX);
                            return component2D.contains(x, y);
                        }
                        case LINE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            return component2D.containsLine(aX, aY, bX, bY);
                        }
                        case TRIANGLE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                            double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                            return component2D.containsTriangle(aX, aY, bX, bY, cX, cY);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }

            @Override
            protected Function<byte[], Component2D.WithinRelation> contains() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double y = XYEncodingUtils.decode(scratchTriangle.aY);
                            double x = XYEncodingUtils.decode(scratchTriangle.aX);
                            return component2D.withinPoint(x, y);
                        }
                        case LINE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            return component2D.withinLine(aX, aY, scratchTriangle.ab, bX, bY);
                        }
                        case TRIANGLE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                            double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                            return component2D.withinTriangle(aX, aY, scratchTriangle.ab, bX, bY, scratchTriangle.bc, cX, cY, scratchTriangle.ca);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }
        };
    }

    @Override
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        return XYShapeQuery.getSpatialVisitor(this.queryComponent2D);
    }
}

