/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.BlockTermState;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.FieldsConsumer;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.FieldsProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90PostingsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90PostingsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReadState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermState;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;

public final class Lucene90PostingsFormat
extends PostingsFormat {
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 128;
    static final int MAX_SKIP_LEVELS = 10;
    static final String TERMS_CODEC = "Lucene90PostingsWriterTerms";
    static final String DOC_CODEC = "Lucene90PostingsWriterDoc";
    static final String POS_CODEC = "Lucene90PostingsWriterPos";
    static final String PAY_CODEC = "Lucene90PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;

    public Lucene90PostingsFormat() {
        this(25, 48);
    }

    public Lucene90PostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        super("Lucene90");
        Lucene90BlockTreeTermsWriter.validateSettings(minTermBlockSize, maxTermBlockSize);
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        Lucene90BlockTreeTermsWriter lucene90BlockTreeTermsWriter;
        block3: {
            Lucene90PostingsWriter postingsWriter = new Lucene90PostingsWriter(state);
            boolean success = false;
            try {
                Lucene90BlockTreeTermsWriter ret = new Lucene90BlockTreeTermsWriter(state, postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                lucene90BlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return lucene90BlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene90BlockTreeTermsReader lucene90BlockTreeTermsReader;
        block3: {
            Lucene90PostingsReader postingsReader = new Lucene90PostingsReader(state);
            boolean success = false;
            try {
                Lucene90BlockTreeTermsReader ret = new Lucene90BlockTreeTermsReader(postingsReader, state);
                success = true;
                lucene90BlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return lucene90BlockTreeTermsReader;
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long skipOffset = -1L;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        @Override
        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.skipOffset = other.skipOffset;
            this.singletonDocID = other.singletonDocID;
        }

        @Override
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

