/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.ArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.MutablePointTree;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PointsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PointsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90PointsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergeState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PointValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentWriteState;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.BKDConfig;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.bkd.BKDWriter;

public class Lucene90PointsWriter
extends PointsWriter {
    protected final IndexOutput metaOut;
    protected final IndexOutput indexOut;
    protected final IndexOutput dataOut;
    final SegmentWriteState writeState;
    final int maxPointsInLeafNode;
    final double maxMBSortInHeap;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene90PointsWriter(SegmentWriteState writeState, int maxPointsInLeafNode, double maxMBSortInHeap) throws IOException {
        assert (writeState.fieldInfos.hasPointValues());
        this.writeState = writeState;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxMBSortInHeap = maxMBSortInHeap;
        String dataFileName = IndexFileNames.segmentFileName(writeState.segmentInfo.name, writeState.segmentSuffix, "kdd");
        this.dataOut = writeState.directory.createOutput(dataFileName, writeState.context);
        boolean success = false;
        try {
            CodecUtil.writeIndexHeader(this.dataOut, "Lucene90PointsFormatData", 0, writeState.segmentInfo.getId(), writeState.segmentSuffix);
            String metaFileName = IndexFileNames.segmentFileName(writeState.segmentInfo.name, writeState.segmentSuffix, "kdm");
            this.metaOut = writeState.directory.createOutput(metaFileName, writeState.context);
            CodecUtil.writeIndexHeader(this.metaOut, "Lucene90PointsFormatMeta", 0, writeState.segmentInfo.getId(), writeState.segmentSuffix);
            String indexFileName = IndexFileNames.segmentFileName(writeState.segmentInfo.name, writeState.segmentSuffix, "kdi");
            this.indexOut = writeState.directory.createOutput(indexFileName, writeState.context);
            CodecUtil.writeIndexHeader(this.indexOut, "Lucene90PointsFormatIndex", 0, writeState.segmentInfo.getId(), writeState.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    public Lucene90PointsWriter(SegmentWriteState writeState) throws IOException {
        this(writeState, 512, 16.0);
    }

    @Override
    public void writeField(FieldInfo fieldInfo, PointsReader reader) throws IOException {
        PointValues.PointTree values = reader.getValues(fieldInfo.name).getPointTree();
        BKDConfig config = new BKDConfig(fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), this.maxPointsInLeafNode);
        try (final BKDWriter writer = new BKDWriter(this.writeState.segmentInfo.maxDoc(), this.writeState.directory, this.writeState.segmentInfo.name, config, this.maxMBSortInHeap, values.size());){
            if (values instanceof MutablePointTree) {
                Runnable finalizer = writer.writeField(this.metaOut, this.indexOut, this.dataOut, fieldInfo.name, (MutablePointTree)values);
                if (finalizer != null) {
                    this.metaOut.writeInt(fieldInfo.number);
                    finalizer.run();
                }
                return;
            }
            values.visitDocValues(new PointValues.IntersectVisitor(){

                @Override
                public void visit(int docID) {
                    throw new IllegalStateException();
                }

                @Override
                public void visit(int docID, byte[] packedValue) throws IOException {
                    writer.add(packedValue, docID);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
            Runnable finalizer = writer.finish(this.metaOut, this.indexOut, this.dataOut);
            if (finalizer != null) {
                this.metaOut.writeInt(fieldInfo.number);
                finalizer.run();
            }
        }
    }

    @Override
    public void merge(MergeState mergeState) throws IOException {
        for (PointsReader reader : mergeState.pointsReaders) {
            if (reader instanceof Lucene90PointsReader) continue;
            super.merge(mergeState);
            return;
        }
        for (PointsReader reader : mergeState.pointsReaders) {
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (fieldInfo.getPointDimensionCount() == 0) continue;
            if (fieldInfo.getPointDimensionCount() == 1) {
                long totMaxSize = 0L;
                for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
                    PointValues values;
                    FieldInfos readerFieldInfos;
                    FieldInfo readerFieldInfo;
                    PointsReader reader = mergeState.pointsReaders[i];
                    if (reader == null || (readerFieldInfo = (readerFieldInfos = mergeState.fieldInfos[i]).fieldInfo(fieldInfo.name)) == null || readerFieldInfo.getPointDimensionCount() <= 0 || (values = reader.getValues(fieldInfo.name)) == null) continue;
                    totMaxSize += values.size();
                }
                BKDConfig config = new BKDConfig(fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), this.maxPointsInLeafNode);
                BKDWriter writer = new BKDWriter(this.writeState.segmentInfo.maxDoc(), this.writeState.directory, this.writeState.segmentInfo.name, config, this.maxMBSortInHeap, totMaxSize);
                try {
                    ArrayList<PointValues> pointValues = new ArrayList<PointValues>();
                    ArrayList<MergeState.DocMap> docMaps = new ArrayList<MergeState.DocMap>();
                    for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
                        PointValues aPointValues;
                        PointsReader reader = mergeState.pointsReaders[i];
                        if (reader == null) continue;
                        assert (reader instanceof Lucene90PointsReader);
                        Lucene90PointsReader reader90 = (Lucene90PointsReader)reader;
                        FieldInfos readerFieldInfos = mergeState.fieldInfos[i];
                        FieldInfo readerFieldInfo = readerFieldInfos.fieldInfo(fieldInfo.name);
                        if (readerFieldInfo == null || readerFieldInfo.getPointDimensionCount() <= 0 || (aPointValues = reader90.readers.get(readerFieldInfo.number)) == null) continue;
                        pointValues.add(aPointValues);
                        docMaps.add(mergeState.docMaps[i]);
                    }
                    Runnable finalizer = writer.merge(this.metaOut, this.indexOut, this.dataOut, docMaps, pointValues);
                    if (finalizer == null) continue;
                    this.metaOut.writeInt(fieldInfo.number);
                    finalizer.run();
                    continue;
                }
                finally {
                    writer.close();
                    continue;
                }
            }
            this.mergeOneField(mergeState, fieldInfo);
        }
        this.finish();
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.metaOut.writeInt(-1);
        CodecUtil.writeFooter(this.indexOut);
        CodecUtil.writeFooter(this.dataOut);
        this.metaOut.writeLong(this.indexOut.getFilePointer());
        this.metaOut.writeLong(this.dataOut.getFilePointer());
        CodecUtil.writeFooter(this.metaOut);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.metaOut, this.indexOut, this.dataOut);
    }
}

