/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.eu;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.LowerCaseFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.WordlistLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.snowball.SnowballFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.opensearch2.org.tartarus.snowball.ext.BasqueStemmer;

public final class BasqueAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public BasqueAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public BasqueAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public BasqueAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new SnowballFilter((TokenStream)result, new BasqueStemmer());
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(BasqueAnalyzer.class.getResourceAsStream(BasqueAnalyzer.DEFAULT_STOPWORD_FILE), BasqueAnalyzer.DEFAULT_STOPWORD_FILE), "#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

