/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.tdunning.math.stats;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.graylog.shaded.opensearch2.com.tdunning.math.stats.Simple64;

public class FloatHistogram
implements Serializable {
    private long[] counts;
    private double min;
    private double max;
    private int bitsOfPrecision;
    private int shift;
    private int offset;

    FloatHistogram() {
    }

    public FloatHistogram(double min, double max) {
        this(min, max, 50.0);
    }

    public FloatHistogram(double min, double max, double binsPerDecade) {
        if (max <= 2.0 * min) {
            throw new IllegalArgumentException(String.format("Illegal/nonsensical min, max (%.2f, %.2g)", min, max));
        }
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("Min and max must be positive");
        }
        if (binsPerDecade < 5.0 || binsPerDecade > 10000.0) {
            throw new IllegalArgumentException(String.format("Unreasonable number of bins per decade %.2g. Expected value in range [5,10000]", binsPerDecade));
        }
        this.min = min;
        this.max = max;
        this.bitsOfPrecision = (int)Math.ceil(Math.log(binsPerDecade * Math.log10(2.0)) / Math.log(2.0));
        this.shift = 52 - this.bitsOfPrecision;
        this.offset = 1023 << this.bitsOfPrecision;
        int binCount = this.bucketIndex(max) + 1;
        if (binCount > 10000) {
            throw new IllegalArgumentException(String.format("Excessive number of bins %d resulting from min,max,binsPerDecade = %.2g, %.2g, %.2g", binCount, min, max, binsPerDecade));
        }
        this.counts = new long[binCount];
    }

    int bucket(double x) {
        if (x <= this.min) {
            return 0;
        }
        if (x >= this.max) {
            return this.counts.length - 1;
        }
        return this.bucketIndex(x);
    }

    private int bucketIndex(double x) {
        long floatBits = Double.doubleToLongBits(x /= this.min);
        return (int)(floatBits >>> this.shift) - this.offset;
    }

    private double lowerBound(int k) {
        return this.min * Double.longBitsToDouble((long)k + (1023L << this.bitsOfPrecision) << 52 - this.bitsOfPrecision);
    }

    public void add(double v) {
        int n = this.bucket(v);
        this.counts[n] = this.counts[n] + 1L;
    }

    public double[] getBounds() {
        double[] r = new double[this.counts.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.lowerBound(i);
        }
        return r;
    }

    public long[] getCounts() {
        return this.counts;
    }

    public long[] getCompressedCounts() {
        LongBuffer buf = LongBuffer.allocate(this.counts.length);
        Simple64.compress(buf, this.counts, 0, this.counts.length);
        long[] r = new long[buf.position()];
        buf.flip();
        buf.get(r);
        return r;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeByte(this.bitsOfPrecision);
        out.writeByte(this.shift);
        ByteBuffer buf = ByteBuffer.allocate(8 * this.counts.length);
        LongBuffer longBuffer = buf.asLongBuffer();
        Simple64.compress(longBuffer, this.counts, 0, this.counts.length);
        buf.position(8 * longBuffer.position());
        byte[] r = new byte[buf.position()];
        out.writeShort(buf.position());
        buf.flip();
        buf.get(r);
        out.write(r);
    }

    public void readObject(ObjectInputStream in) throws IOException {
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.bitsOfPrecision = in.readByte();
        this.shift = in.readByte();
        this.offset = 1023 << this.bitsOfPrecision;
        short n = in.readShort();
        ByteBuffer buf = ByteBuffer.allocate(n);
        in.readFully(buf.array(), 0, n);
        int binCount = this.bucketIndex(this.max) + 1;
        if (binCount > 10000) {
            throw new IllegalArgumentException(String.format("Excessive number of bins %d during deserialization = %.2g, %.2g", binCount, this.min, this.max));
        }
        this.counts = new long[binCount];
        Simple64.decompress(buf.asLongBuffer(), this.counts);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }
}

