/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.FinalRequestProcessor;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.Request;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.SyncRequestProcessor;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ZKDatabase;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.ZooKeeperServer;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.persistence.FileTxnSnapLog;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.CommitProcessor;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.Learner;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.Observer;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.ObserverRequestProcessor;
import org.graylog.shaded.org.apache.kafka09.zookeeper.server.quorum.QuorumPeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverZooKeeperServer.class);
    private boolean syncRequestProcessorEnabled;
    private CommitProcessor commitProcessor;
    private SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs;

    ObserverZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
        this.syncRequestProcessorEnabled = this.self.getSyncEnabled();
        this.pendingSyncs = new ConcurrentLinkedQueue();
        LOG.info("syncEnabled =" + this.syncRequestProcessorEnabled);
    }

    public Observer getObserver() {
        return this.self.observer;
    }

    public Learner getLearner() {
        return this.self.observer;
    }

    public void commitRequest(Request request) {
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor.processRequest(request);
        }
        this.commitProcessor.commit(request);
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true);
        this.commitProcessor.start();
        this.firstProcessor = new ObserverRequestProcessor(this, this.commitProcessor);
        ((ObserverRequestProcessor)this.firstProcessor).start();
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor = new SyncRequestProcessor(this, null);
            this.syncProcessor.start();
        }
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    public String getState() {
        return "observer";
    }

    public void shutdown() {
        super.shutdown();
        if (this.syncRequestProcessorEnabled && this.syncProcessor != null) {
            this.syncProcessor.shutdown();
        }
    }
}

