/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.zookeeper;

import java.util.List;
import jline.Completor;
import org.graylog.shaded.org.apache.kafka09.zookeeper.KeeperException;
import org.graylog.shaded.org.apache.kafka09.zookeeper.ZooKeeper;
import org.graylog.shaded.org.apache.kafka09.zookeeper.ZooKeeperMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JLineZNodeCompletor
implements Completor {
    private ZooKeeper zk;

    public JLineZNodeCompletor(ZooKeeper zk) {
        this.zk = zk;
    }

    public int complete(String buffer, int cursor, List candidates) {
        String[] tokens;
        buffer = buffer.substring(0, cursor);
        String token2 = "";
        if (!buffer.endsWith(" ") && (tokens = buffer.split(" ")).length != 0) {
            token2 = tokens[tokens.length - 1];
        }
        if (token2.startsWith("/")) {
            return this.completeZNode(buffer, token2, candidates);
        }
        return this.completeCommand(buffer, token2, candidates);
    }

    private int completeCommand(String buffer, String token2, List<String> candidates) {
        for (String cmd : ZooKeeperMain.getCommands()) {
            if (!cmd.startsWith(token2)) continue;
            candidates.add(cmd);
        }
        return buffer.lastIndexOf(" ") + 1;
    }

    private int completeZNode(String buffer, String token2, List<String> candidates) {
        String path = token2;
        int idx = path.lastIndexOf("/") + 1;
        String prefix = path.substring(idx);
        try {
            String dir = idx == 1 ? "/" : path.substring(0, idx - 1);
            List<String> children = this.zk.getChildren(dir, false);
            for (String child : children) {
                if (!child.startsWith(prefix)) continue;
                candidates.add(child);
            }
        }
        catch (InterruptedException e) {
            return 0;
        }
        catch (KeeperException e) {
            return 0;
        }
        return candidates.size() == 0 ? buffer.length() : buffer.lastIndexOf("/") + 1;
    }
}

