/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.serialization;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.errors.SerializationException;
import org.graylog.shaded.org.apache.kafka09.common.serialization.Deserializer;

public class StringDeserializer
implements Deserializer<String> {
    private String encoding = "UTF8";

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.deserializer.encoding" : "value.deserializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("deserializer.encoding");
        }
        if (encodingValue != null && encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    @Override
    public String deserialize(String topic, byte[] data) {
        try {
            if (data == null) {
                return null;
            }
            return new String(data, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when deserializing byte[] to string due to unsupported encoding " + this.encoding);
        }
    }

    @Override
    public void close() {
    }
}

