/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.serialization;

import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.errors.SerializationException;
import org.graylog.shaded.org.apache.kafka09.common.serialization.Deserializer;

public class LongDeserializer
implements Deserializer<Long> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Long deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 8) {
            throw new SerializationException("Size of data received by LongDeserializer is not 8");
        }
        long value2 = 0L;
        for (byte b : data) {
            value2 <<= 8;
            value2 |= (long)(b & 0xFF);
        }
        return value2;
    }

    @Override
    public void close() {
    }
}

