/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.TopicPartition;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.Errors;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ProtoUtils;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Schema;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;

public class StopReplicaResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.STOP_REPLICA.id);
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITIONS_TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_PARTITION_KEY_NAME = "partition";
    private static final String PARTITIONS_ERROR_CODE_KEY_NAME = "error_code";
    private final Map<TopicPartition, Short> responses;
    private final short errorCode;

    public StopReplicaResponse(Map<TopicPartition, Short> responses) {
        this(Errors.NONE.code(), responses);
    }

    public StopReplicaResponse(short errorCode, Map<TopicPartition, Short> responses) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set("error_code", (Object)errorCode);
        ArrayList<Struct> responseDatas = new ArrayList<Struct>(responses.size());
        for (Map.Entry<TopicPartition, Short> response : responses.entrySet()) {
            Struct partitionData = this.struct.instance(PARTITIONS_KEY_NAME);
            TopicPartition partition2 = response.getKey();
            partitionData.set(PARTITIONS_TOPIC_KEY_NAME, (Object)partition2.topic());
            partitionData.set(PARTITIONS_PARTITION_KEY_NAME, (Object)partition2.partition());
            partitionData.set("error_code", (Object)response.getValue());
            responseDatas.add(partitionData);
        }
        this.struct.set(PARTITIONS_KEY_NAME, (Object)responseDatas.toArray());
        this.struct.set("error_code", (Object)errorCode);
        this.responses = responses;
        this.errorCode = errorCode;
    }

    public StopReplicaResponse(Struct struct) {
        super(struct);
        this.responses = new HashMap<TopicPartition, Short>();
        for (Object responseDataObj : struct.getArray(PARTITIONS_KEY_NAME)) {
            Struct responseData = (Struct)responseDataObj;
            String topic = responseData.getString(PARTITIONS_TOPIC_KEY_NAME);
            int partition2 = responseData.getInt(PARTITIONS_PARTITION_KEY_NAME);
            short errorCode = responseData.getShort("error_code");
            this.responses.put(new TopicPartition(topic, partition2), errorCode);
        }
        this.errorCode = struct.getShort("error_code");
    }

    public Map<TopicPartition, Short> responses() {
        return this.responses;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public static StopReplicaResponse parse(ByteBuffer buffer, int versionId) {
        return new StopReplicaResponse(ProtoUtils.parseRequest(ApiKeys.STOP_REPLICA.id, versionId, buffer));
    }

    public static StopReplicaResponse parse(ByteBuffer buffer) {
        return new StopReplicaResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

