/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.TopicPartition;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ProtoUtils;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Schema;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;
import org.graylog.shaded.org.apache.kafka09.common.utils.CollectionUtils;

public class OffsetCommitResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.OFFSET_COMMIT.id);
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final Map<TopicPartition, Short> responseData;

    public OffsetCommitResponse(Map<TopicPartition, Short> responseData) {
        super(new Struct(CURRENT_SCHEMA));
        Map<String, Map<Integer, Short>> topicsData = CollectionUtils.groupDataByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Short>> entries : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, Short> partitionEntry : entries.getValue().entrySet()) {
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(ERROR_CODE_KEY_NAME, (Object)partitionEntry.getValue());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        this.responseData = responseData;
    }

    public OffsetCommitResponse(Struct struct) {
        super(struct);
        this.responseData = new HashMap<TopicPartition, Short>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition2 = partitionResponse.getInt(PARTITION_KEY_NAME);
                short errorCode = partitionResponse.getShort(ERROR_CODE_KEY_NAME);
                this.responseData.put(new TopicPartition(topic, partition2), errorCode);
            }
        }
    }

    public Map<TopicPartition, Short> responseData() {
        return this.responseData;
    }

    public static OffsetCommitResponse parse(ByteBuffer buffer) {
        return new OffsetCommitResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

