/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.Errors;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ProtoUtils;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Schema;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;
import org.graylog.shaded.org.apache.kafka09.common.requests.JoinGroupResponse;

public class JoinGroupRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.JOIN_GROUP.id);
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String SESSION_TIMEOUT_KEY_NAME = "session_timeout";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private static final String GROUP_PROTOCOLS_KEY_NAME = "group_protocols";
    private static final String PROTOCOL_NAME_KEY_NAME = "protocol_name";
    private static final String PROTOCOL_METADATA_KEY_NAME = "protocol_metadata";
    public static final String UNKNOWN_MEMBER_ID = "";
    private final String groupId;
    private final int sessionTimeout;
    private final String memberId;
    private final String protocolType;
    private final List<ProtocolMetadata> groupProtocols;

    public JoinGroupRequest(String groupId, int sessionTimeout, String memberId, String protocolType, List<ProtocolMetadata> groupProtocols) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.struct.set(SESSION_TIMEOUT_KEY_NAME, (Object)sessionTimeout);
        this.struct.set(MEMBER_ID_KEY_NAME, (Object)memberId);
        this.struct.set(PROTOCOL_TYPE_KEY_NAME, (Object)protocolType);
        ArrayList<Struct> groupProtocolsList = new ArrayList<Struct>();
        for (ProtocolMetadata protocol : groupProtocols) {
            Struct protocolStruct = this.struct.instance(GROUP_PROTOCOLS_KEY_NAME);
            protocolStruct.set(PROTOCOL_NAME_KEY_NAME, (Object)protocol.name);
            protocolStruct.set(PROTOCOL_METADATA_KEY_NAME, (Object)protocol.metadata);
            groupProtocolsList.add(protocolStruct);
        }
        this.struct.set(GROUP_PROTOCOLS_KEY_NAME, (Object)groupProtocolsList.toArray());
        this.groupId = groupId;
        this.sessionTimeout = sessionTimeout;
        this.memberId = memberId;
        this.protocolType = protocolType;
        this.groupProtocols = groupProtocols;
    }

    public JoinGroupRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.sessionTimeout = struct.getInt(SESSION_TIMEOUT_KEY_NAME);
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
        this.protocolType = struct.getString(PROTOCOL_TYPE_KEY_NAME);
        this.groupProtocols = new ArrayList<ProtocolMetadata>();
        for (Object groupProtocolObj : struct.getArray(GROUP_PROTOCOLS_KEY_NAME)) {
            Struct groupProtocolStruct = (Struct)groupProtocolObj;
            String name = groupProtocolStruct.getString(PROTOCOL_NAME_KEY_NAME);
            ByteBuffer metadata = groupProtocolStruct.getBytes(PROTOCOL_METADATA_KEY_NAME);
            this.groupProtocols.add(new ProtocolMetadata(name, metadata));
        }
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                return new JoinGroupResponse(Errors.forException(e).code(), -1, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, Collections.emptyMap());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.JOIN_GROUP.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<ProtocolMetadata> groupProtocols() {
        return this.groupProtocols;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public static JoinGroupRequest parse(ByteBuffer buffer, int versionId) {
        return new JoinGroupRequest(ProtoUtils.parseRequest(ApiKeys.JOIN_GROUP.id, versionId, buffer));
    }

    public static JoinGroupRequest parse(ByteBuffer buffer) {
        return new JoinGroupRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }

    public static class ProtocolMetadata {
        private final String name;
        private final ByteBuffer metadata;

        public ProtocolMetadata(String name, ByteBuffer metadata) {
            this.name = name;
            this.metadata = metadata;
        }

        public String name() {
            return this.name;
        }

        public ByteBuffer metadata() {
            return this.metadata;
        }
    }
}

