/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;
import org.graylog.shaded.org.apache.kafka09.common.requests.ControlledShutdownRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.DescribeGroupsRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.FetchRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.GroupCoordinatorRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.HeartbeatRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.JoinGroupRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.LeaderAndIsrRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.LeaveGroupRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.ListGroupsRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.ListOffsetRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.MetadataRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.OffsetCommitRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.OffsetFetchRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.ProduceRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.StopReplicaRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.SyncGroupRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.UpdateMetadataRequest;

public abstract class AbstractRequest
extends AbstractRequestResponse {
    public AbstractRequest(Struct struct) {
        super(struct);
    }

    public abstract AbstractRequestResponse getErrorResponse(int var1, Throwable var2);

    public static AbstractRequest getRequest(int requestId, int versionId, ByteBuffer buffer) {
        switch (ApiKeys.forId(requestId)) {
            case PRODUCE: {
                return ProduceRequest.parse(buffer, versionId);
            }
            case FETCH: {
                return FetchRequest.parse(buffer, versionId);
            }
            case LIST_OFFSETS: {
                return ListOffsetRequest.parse(buffer, versionId);
            }
            case METADATA: {
                return MetadataRequest.parse(buffer, versionId);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(buffer, versionId);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(buffer, versionId);
            }
            case GROUP_COORDINATOR: {
                return GroupCoordinatorRequest.parse(buffer, versionId);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(buffer, versionId);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(buffer, versionId);
            }
            case LEAVE_GROUP: {
                return LeaveGroupRequest.parse(buffer, versionId);
            }
            case SYNC_GROUP: {
                return SyncGroupRequest.parse(buffer, versionId);
            }
            case STOP_REPLICA: {
                return StopReplicaRequest.parse(buffer, versionId);
            }
            case CONTROLLED_SHUTDOWN_KEY: {
                return ControlledShutdownRequest.parse(buffer, versionId);
            }
            case UPDATE_METADATA_KEY: {
                return UpdateMetadataRequest.parse(buffer, versionId);
            }
            case LEADER_AND_ISR: {
                return LeaderAndIsrRequest.parse(buffer, versionId);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsRequest.parse(buffer, versionId);
            }
            case LIST_GROUPS: {
                return ListGroupsRequest.parse(buffer, versionId);
            }
        }
        return null;
    }
}

