/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.protocol;

import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.errors.ApiException;
import org.graylog.shaded.org.apache.kafka09.common.errors.AuthorizationException;
import org.graylog.shaded.org.apache.kafka09.common.errors.BrokerNotAvailableException;
import org.graylog.shaded.org.apache.kafka09.common.errors.ControllerMovedException;
import org.graylog.shaded.org.apache.kafka09.common.errors.CorruptRecordException;
import org.graylog.shaded.org.apache.kafka09.common.errors.GroupCoordinatorNotAvailableException;
import org.graylog.shaded.org.apache.kafka09.common.errors.GroupLoadInProgressException;
import org.graylog.shaded.org.apache.kafka09.common.errors.IllegalGenerationException;
import org.graylog.shaded.org.apache.kafka09.common.errors.InvalidRequiredAcksException;
import org.graylog.shaded.org.apache.kafka09.common.errors.InvalidTopicException;
import org.graylog.shaded.org.apache.kafka09.common.errors.LeaderNotAvailableException;
import org.graylog.shaded.org.apache.kafka09.common.errors.NetworkException;
import org.graylog.shaded.org.apache.kafka09.common.errors.NotCoordinatorForGroupException;
import org.graylog.shaded.org.apache.kafka09.common.errors.NotEnoughReplicasAfterAppendException;
import org.graylog.shaded.org.apache.kafka09.common.errors.NotEnoughReplicasException;
import org.graylog.shaded.org.apache.kafka09.common.errors.NotLeaderForPartitionException;
import org.graylog.shaded.org.apache.kafka09.common.errors.OffsetMetadataTooLarge;
import org.graylog.shaded.org.apache.kafka09.common.errors.RebalanceInProgressException;
import org.graylog.shaded.org.apache.kafka09.common.errors.RecordBatchTooLargeException;
import org.graylog.shaded.org.apache.kafka09.common.errors.RecordTooLargeException;
import org.graylog.shaded.org.apache.kafka09.common.errors.TimeoutException;
import org.graylog.shaded.org.apache.kafka09.common.errors.UnknownMemberIdException;
import org.graylog.shaded.org.apache.kafka09.common.errors.UnknownServerException;
import org.graylog.shaded.org.apache.kafka09.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Errors {
    UNKNOWN(-1, new UnknownServerException("The server experienced an unexpected error when processing the request")),
    NONE(0, null),
    OFFSET_OUT_OF_RANGE(1, new ApiException("The requested offset is not within the range of offsets maintained by the server.")),
    CORRUPT_MESSAGE(2, new CorruptRecordException("The message contents does not match the message CRC or the message is otherwise corrupt.")),
    UNKNOWN_TOPIC_OR_PARTITION(3, new UnknownTopicOrPartitionException("This server does not host this topic-partition.")),
    LEADER_NOT_AVAILABLE(5, new LeaderNotAvailableException("There is no leader for this topic-partition as we are in the middle of a leadership election.")),
    NOT_LEADER_FOR_PARTITION(6, new NotLeaderForPartitionException("This server is not the leader for that topic-partition.")),
    REQUEST_TIMED_OUT(7, new TimeoutException("The request timed out.")),
    BROKER_NOT_AVAILABLE(8, new BrokerNotAvailableException("The broker is not available.")),
    REPLICA_NOT_AVAILABLE(9, new ApiException("The replica is not available for the requested topic-partition")),
    MESSAGE_TOO_LARGE(10, new RecordTooLargeException("The request included a message larger than the max message size the server will accept.")),
    STALE_CONTROLLER_EPOCH(11, new ControllerMovedException("The controller moved to another broker.")),
    OFFSET_METADATA_TOO_LARGE(12, new OffsetMetadataTooLarge("The metadata field of the offset request was too large.")),
    NETWORK_EXCEPTION(13, new NetworkException("The server disconnected before a response was received.")),
    GROUP_LOAD_IN_PROGRESS(14, new GroupLoadInProgressException("The coordinator is loading and hence can't process requests for this group.")),
    GROUP_COORDINATOR_NOT_AVAILABLE(15, new GroupCoordinatorNotAvailableException("The group coordinator is not available.")),
    NOT_COORDINATOR_FOR_GROUP(16, new NotCoordinatorForGroupException("This is not the correct coordinator for this group.")),
    INVALID_TOPIC_EXCEPTION(17, new InvalidTopicException("The request attempted to perform an operation on an invalid topic.")),
    RECORD_LIST_TOO_LARGE(18, new RecordBatchTooLargeException("The request included message batch larger than the configured segment size on the server.")),
    NOT_ENOUGH_REPLICAS(19, new NotEnoughReplicasException("Messages are rejected since there are fewer in-sync replicas than required.")),
    NOT_ENOUGH_REPLICAS_AFTER_APPEND(20, new NotEnoughReplicasAfterAppendException("Messages are written to the log, but to fewer in-sync replicas than required.")),
    INVALID_REQUIRED_ACKS(21, new InvalidRequiredAcksException("Produce request specified an invalid value for required acks.")),
    ILLEGAL_GENERATION(22, new IllegalGenerationException("Specified group generation id is not valid.")),
    INCONSISTENT_GROUP_PROTOCOL(23, new ApiException("The group member's supported protocols are incompatible with those of existing members.")),
    INVALID_GROUP_ID(24, new ApiException("The configured groupId is invalid")),
    UNKNOWN_MEMBER_ID(25, new UnknownMemberIdException("The coordinator is not aware of this member.")),
    INVALID_SESSION_TIMEOUT(26, new ApiException("The session timeout is not within an acceptable range.")),
    REBALANCE_IN_PROGRESS(27, new RebalanceInProgressException("The group is rebalancing, so a rejoin is needed.")),
    INVALID_COMMIT_OFFSET_SIZE(28, new ApiException("The committing offset data size is not valid")),
    TOPIC_AUTHORIZATION_FAILED(29, new AuthorizationException("Topic authorization failed.")),
    GROUP_AUTHORIZATION_FAILED(30, new AuthorizationException("Group authorization failed.")),
    CLUSTER_AUTHORIZATION_FAILED(31, new AuthorizationException("Cluster authorization failed."));

    private static final Logger log;
    private static Map<Class<?>, Errors> classToError;
    private static Map<Short, Errors> codeToError;
    private final short code;
    private final ApiException exception;

    private Errors(int code, ApiException exception) {
        this.code = (short)code;
        this.exception = exception;
    }

    public ApiException exception() {
        return this.exception;
    }

    public short code() {
        return this.code;
    }

    public void maybeThrow() {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public static Errors forCode(short code) {
        Errors error = codeToError.get(code);
        if (error != null) {
            return error;
        }
        log.warn("Unexpected error code: {}.", (Object)code);
        return UNKNOWN;
    }

    public static Errors forException(Throwable t) {
        Errors error = classToError.get(t.getClass());
        return error == null ? UNKNOWN : error;
    }

    static {
        log = LoggerFactory.getLogger(Errors.class);
        classToError = new HashMap();
        codeToError = new HashMap<Short, Errors>();
        for (Errors error : Errors.values()) {
            codeToError.put(error.code(), error);
            if (error.exception == null) continue;
            classToError.put(error.exception.getClass(), error);
        }
    }
}

